package com.ebmwebsourcing.easywsdl11.impl;

import java.util.logging.Logger;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.type.TImport;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTImport;

class TImportImpl extends
AbstractTExtensibleAttributesDocumentedImpl<EJaxbTImport> implements
TImport {

    private static Logger LOG = Logger.getLogger(TImportImpl.class
            .getName());

    protected TImportImpl(XmlContext xmlContext, EJaxbTImport jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTImport> getCompliantModelClass() {
        return EJaxbTImport.class;
    }

    @Override
    public boolean hasNamespace() {
        return getModelObject().getNamespace() != null;
    }

    @Override
    public String getNamespace() {
        return getModelObject().getNamespace();
    }

    @Override
    public void setNamespace(String namespace) {
        getModelObject().setNamespace(namespace);
    }

    @Override
    public boolean hasLocation() {
        return getModelObject().getLocation() != null;
    }

    @Override
    public String getLocation() {
        return getModelObject().getLocation();
    }

    @Override
    public void setLocation(String location) {
        getModelObject().setLocation(location);
    }

    @Override
    public final XmlObject[] getXmlObjectAdoptedChildren() {
        XmlObject adoptedWsdl = adoptChild(getNamespace(), getLocation(), 0);
        return new XmlObject[] { adoptedWsdl };
    }
}
