package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easywsdl11.api.type.TPart;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPart;

class TPartImpl extends AbstractTExtensibleAttributesDocumentedImpl<EJaxbTPart>
        implements TPart {

    protected TPartImpl(XmlContext xmlContext, EJaxbTPart jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTPart> getCompliantModelClass() {
        return EJaxbTPart.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasElement() {
        return getElement() != null;
    }

    @Override
    public QName getElement() {
        return getModelObject().getElement();
    }

    @Override
    public void setElement(QName qname) {
        getModelObject().setElement(qname);
    }

    @Override
    public boolean hasType() {
        return getType() != null;
    }

    @Override
    public QName getType() {
        return getModelObject().getType();
    }

    @Override
    public void setType(QName qname) {
        getModelObject().setType(qname);
    }

    @Override
    public Element findElement() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext()
                .createXPathEvaluator();
        QName elementQName = getElement();
        if (elementQName == null)
            return null;
        try {
            Element result = xpathEvaluator
                    .selectSingleXmlObjectNode(
                            getXmlObjectBaseRoot(),
                            String.format(
                                    "//xs:schema[@targetNamespace='%s']//xs:element[@name='%s']",
                                    elementQName.getNamespaceURI(),
                                    elementQName.getLocalPart()), Element.class);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }


}
