package com.ebmwebsourcing.easywsdl11.impl;

import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTExtensibleAttributesDocumented;

abstract class AbstractTExtensibleAttributesDocumentedImpl<Model extends EJaxbTExtensibleAttributesDocumented>
        extends AbstractTDocumentedImpl<Model> implements WithOtherAttributes {

    protected AbstractTExtensibleAttributesDocumentedImpl(
            XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final void addOtherAttribute(QName qname, String value) {
        getModelObject().getOtherAttributes().put(qname, value);
    }

    @Override
    public final void clearOtherAttributes() {
        getModelObject().getOtherAttributes().clear();
    }

    @Override
    public final String getOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().get(qname);
    }

    @Override
    public final Map<QName, String> getOtherAttributes() {
        return new HashMap<QName, String>(getModelObject().getOtherAttributes());
    }

    @Override
    public final boolean hasOtherAttribute(QName qname) {
        return getModelObject().getOtherAttributes().containsKey(qname);
    }

    @Override
    public final void removeOtherAttribute(QName qname) {
        getModelObject().getOtherAttributes().remove(qname);
    }

}
