package com.ebmwebsourcing.easywsdl11.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easywsdl11.api.type.TExtensibleDocumented;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTExtensibleDocumented;

abstract class AbstractTExtensibleDocumentedImpl<Model extends EJaxbTExtensibleDocumented>
        extends AbstractTDocumentedImpl<Model> implements TExtensibleDocumented {

    protected AbstractTExtensibleDocumentedImpl(XmlContext xmlContext,
            Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final void addAnyXmlObject(XmlObject anyXmlObject) {
        addToAny(getModelObject().getAny(), anyXmlObject);
    }

    @Override
    public final void clearAnyXmlObjects() {
        clearChildren(getModelObject().getAny(), Object.class,
                AbstractJaxbXmlObjectImpl.ANY_QNAME);
    }

    @Override
    public final <X extends XmlObject> X getFirstAnyXmlObject(
            Class<X> interfaceClass) {
        X[] children = getAnyXmlObjects(interfaceClass);
        if (children.length == 0)
            return null;
        return children[0];
    }

    @Override
    public final XmlObject[] getAnyXmlObjects() {
        XmlObject[] anyXmlObjects = createChildrenArray(getModelObject()
                .getAny(), Object.class, AbstractJaxbXmlObjectImpl.ANY_QNAME);
        return anyXmlObjects;
    }

    @SuppressWarnings("unchecked")
    @Override
    public final <X extends XmlObject> X[] getAnyXmlObjects(
            Class<X> interfaceClass) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!interfaceClass.isInstance(anyXmlObject))
                continue;
            result.add(anyXmlObject);
        }
        return result.toArray((X[]) Array.newInstance(interfaceClass, result.size()));
    }

    @Override
    public final XmlObject[] getAnyXmlObjects(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!qname.equals(anyXmlObject.getXmlObjectQName()))
                continue;
            result.add(anyXmlObject);
        }
        return (XmlObject[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final boolean hasAnyXmlObject(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (qname.equals(anyXmlObject.getXmlObjectQName()))
                return true;
        }
        return false;
    }

    @Override
    public final void removeAnyXmlObject(XmlObject anyXmlObject) {
        removeFromChildren(getModelObject().getAny(), anyXmlObject);
    }

}
