package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easywsdl11.api.element.Message;
import com.ebmwebsourcing.easywsdl11.api.type.TFault;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTFault;

class TFaultImpl extends
        AbstractTExtensibleAttributesDocumentedImpl<EJaxbTFault> implements
        TFault {

    protected TFaultImpl(XmlContext xmlContext, EJaxbTFault jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTFault> getCompliantModelClass() {
        return EJaxbTFault.class;
    }

    @Override
    public boolean hasMessage() {
        return getModelObject().getMessage() != null;
    }

    @Override
    public QName getMessage() {
        return getModelObject().getMessage();
    }

    @Override
    public void setMessage(QName message) {
        getModelObject().setMessage(message);
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }
    
    
    @Override
    public Message findMessage() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext()
        .createXPathEvaluator();
        QName messageQName = getMessage();
        if (messageQName == null) return null;
        try {
            Message result = xpathEvaluator.selectSingleXmlObjectNode(getXmlObjectBaseRoot(), 
                    String.format("//wsdl11:message[@name='%s' and ../@targetNamespace='%s']", 
                            messageQName.getLocalPart(), messageQName.getNamespaceURI()), Message.class);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }

}
