package com.ebmwebsourcing.easywsdl11.impl;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.type.TPort;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTPort;

class TPortImpl extends AbstractTExtensibleDocumentedImpl<EJaxbTPort> implements
        TPort {

    protected TPortImpl(XmlContext xmlContext, EJaxbTPort jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTPort> getCompliantModelClass() {
        return EJaxbTPort.class;
    }

    @Override
    public boolean hasName() {
        return getModelObject().getName() != null;
    }

    @Override
    public String getName() {
        return getModelObject().getName();
    }

    @Override
    public void setName(String name) {
        getModelObject().setName(name);
    }

    @Override
    public boolean hasBinding() {
        return getModelObject().getBinding() != null;
    }

    @Override
    public QName getBinding() {
        return getModelObject().getBinding();
    }

    @Override
    public void setBinding(QName qname) {
        getModelObject().setBinding(qname);
    }
    
    @Override
    public Binding findBinding() {
        XmlObjectXPathEvaluator xpathEvaluator = getXmlContext().createXPathEvaluator();
        QName bindingQName = getBinding();
        try {
            XmlObject root = getXmlObjectRoot();
            Binding result = xpathEvaluator.selectSingleXmlObjectNode(root, 
                    String.format("//wsdl11:binding[@name='%s' and ../@targetNamespace='%s']", 
                            bindingQName.getLocalPart(), bindingQName.getNamespaceURI()), Binding.class);
            return result;
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
    }

}
