/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easywsdl11.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easywsdl11.api.type.TExtensibleDocumented;

import easybox.org.xmlsoap.schemas.wsdl.EJaxbTExtensibleDocumented;

abstract class AbstractTExtensibleDocumentedImpl<Model extends EJaxbTExtensibleDocumented>
        extends AbstractTDocumentedImpl<Model> implements TExtensibleDocumented {

    protected AbstractTExtensibleDocumentedImpl(XmlContext xmlContext,
            Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public final void addAnyXmlObject(XmlObject anyXmlObject) {
        addToAny(getModelObject().getAny(), anyXmlObject);
    }

    @Override
    public final void clearAnyXmlObjects() {
        clearChildren(getModelObject().getAny(), Object.class,
                AbstractJaxbXmlObjectImpl.ANY_QNAME);
    }

    @Override
    public final <X extends XmlObject> X getFirstAnyXmlObject(
            Class<X> interfaceClass) {
        X[] children = getAnyXmlObjects(interfaceClass);
        if (children.length == 0)
            return null;
        return children[0];
    }

    @Override
    public final XmlObject[] getAnyXmlObjects() {
        XmlObject[] anyXmlObjects = createChildrenArray(getModelObject()
                .getAny(), Object.class, AbstractJaxbXmlObjectImpl.ANY_QNAME);
        return anyXmlObjects;
    }

    @SuppressWarnings("unchecked")
    @Override
    public final <X extends XmlObject> X[] getAnyXmlObjects(
            Class<X> interfaceClass) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!interfaceClass.isInstance(anyXmlObject))
                continue;
            result.add(anyXmlObject);
        }
        return result.toArray((X[]) Array.newInstance(interfaceClass, result.size()));
    }

    @Override
    public final XmlObject[] getAnyXmlObjects(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        List<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (!qname.equals(anyXmlObject.getXmlObjectQName()))
                continue;
            result.add(anyXmlObject);
        }
        return (XmlObject[]) result.toArray(new XmlObject[result.size()]);
    }

    @Override
    public final boolean hasAnyXmlObject(QName qname) {
        XmlObject[] anyXmlObjects = getAnyXmlObjects();
        for (XmlObject anyXmlObject : anyXmlObjects) {
            if (qname.equals(anyXmlObject.getXmlObjectQName()))
                return true;
        }
        return false;
    }

    @Override
    public final void removeAnyXmlObject(XmlObject anyXmlObject) {
        removeFromChildren(getModelObject().getAny(), anyXmlObject);
    }

}
