package com.ebmwebsourcing.soapbinding11.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.soapbinding11.api.type.TBinding;
import com.ebmwebsourcing.soapbinding11.api.type.TStyleChoice;

import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTBinding;
import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTStyleChoice;

class TBindingImpl extends AbstractJaxbXmlObjectImpl<EJaxbTBinding>
        implements TBinding {

    protected TBindingImpl(XmlContext xmlContext, EJaxbTBinding jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBinding> getCompliantModelClass() {
        return EJaxbTBinding.class;
    }

	@Override
	public boolean hasTransport() {
		return getModelObject().getTransport() != null;
	}

	@Override
	public String getTransport() {
		return getModelObject().getTransport();
	}

	@Override
	public void setTransport(String transport) {
		getModelObject().setTransport(transport);
	}

	@Override
	public TStyleChoice getStyle() {
		if (getModelObject().getStyle() == null)
            return null;
        return TStyleChoice.valueOf(getModelObject().getStyle().toString().toUpperCase());
	}

	@Override
	public void setStyle(TStyleChoice style) {
		if (style == null) {
            getModelObject().setStyle(null);
        } else if (style.equals(TStyleChoice.DOCUMENT)) {
            getModelObject().setStyle(EJaxbTStyleChoice.DOCUMENT);
        } else {
            getModelObject().setStyle(EJaxbTStyleChoice.RPC);
        }
	}

	@Override
	public boolean hasStyle() {
		return getModelObject().getStyle() != null;
	}


}
