package com.ebmwebsourcing.soapbinding11.impl;

import java.util.Arrays;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.soapbinding11.api.type.TBody;
import com.ebmwebsourcing.soapbinding11.api.type.TUseChoice;

import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbTBody;
import easybox.org.xmlsoap.schemas.wsdl.soap.EJaxbUseChoice;

class TBodyImpl extends AbstractJaxbXmlObjectImpl<EJaxbTBody>
        implements TBody {

    protected TBodyImpl(XmlContext xmlContext, EJaxbTBody jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbTBody> getCompliantModelClass() {
        return EJaxbTBody.class;
    }

	@Override
	public boolean hasEncodingStyle() {
		return this.getModelObject().isSetEncodingStyle();
	}

	@Override
	public String[] getEncodingStyle() {
		return this.getModelObject().getEncodingStyle().toArray(new String[this.getModelObject().getEncodingStyle().size()]);
	}

	@Override
	public void setEncodingStyle(String[] encodingStyle) {
		this.getModelObject().getEncodingStyle().clear();
		this.getModelObject().getEncodingStyle().addAll(Arrays.asList(encodingStyle));
	}

    @Override
    public TUseChoice getUse() {
        TUseChoice res = null;
        if (this.getModelObject().isSetUse()) {
            switch (this.getModelObject().getUse()) {
                case ENCODED:
                    res = TUseChoice.ENCODED;
                    break;
                case LITERAL:
                    res = TUseChoice.LITERAL;
                    break;
            }
        }
        return res;
    }

    @Override
    public void setUse(TUseChoice arg0) {
        if (arg0 != null) {
            switch (arg0) {
                case ENCODED:
                    this.getModelObject().setUse(EJaxbUseChoice.ENCODED);
                    break;
                case LITERAL:
                    this.getModelObject().setUse(EJaxbUseChoice.LITERAL);
                    break;
            }
        } else {
            this.getModelObject().setUse(null);
        }
    }

    @Override
    public boolean hasUse() {
        return this.getModelObject().isSetUse();
    }

	@Override
	public String getNamespace() {
		return this.getModelObject().getNamespace();
	}

	@Override
	public boolean hasNamespace() {
		return this.getNamespace() != null;
	}

	@Override
	public void setNamespace(String arg0) {
		this.getModelObject().setNamespace(arg0);
	}

	@Override
	public boolean hasParts() {
		return this.getParts() != null;
	}

	@Override
	public String[] getParts() {
		return this.getModelObject().getParts().toArray(new String[this.getModelObject().getParts().size()]);
	}

	@Override
	public void setParts(String[] parts) {
		this.getModelObject().getParts().clear();
		this.getModelObject().getParts().addAll(Arrays.asList(parts));
	}




}
