package com.ebmwebsourcing.soapbinding11.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.soapbinding11.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "soapbinding11-impl";
    }

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/soapbinding11";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "soapbinding11.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.xmlsoap.schemas.wsdl.soap.ObjectFactory.class
                .getPackage();
    }

    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.SOAPBINDING11_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.SOAPBINDING11_NS_PREFERRED_PREFIX;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();

        // elements
        factorableClasses.add(BindingImpl.class);
        factorableClasses.add(AddressImpl.class);
        factorableClasses.add(OperationImpl.class);
        factorableClasses.add(BodyImpl.class);
        factorableClasses.add(HeaderImpl.class);
        factorableClasses.add(FaultImpl.class);
        // factorableClasses.add(BindingOperationImpl.class);
        // factorableClasses.add(BindingOperationFaultImpl.class);
        // factorableClasses.add(BindingOperationInputImpl.class);
        // factorableClasses.add(BindingOperationOutputImpl.class);
        // factorableClasses.add(DefinitionsImpl.class);
        // factorableClasses.add(DocumentationImpl.class);
        // factorableClasses.add(FaultImpl.class);
        // factorableClasses.add(ImportImpl.class);
        // factorableClasses.add(InputImpl.class);
        // factorableClasses.add(MessageImpl.class);
        // factorableClasses.add(OperationImpl.class);
        // factorableClasses.add(OutputImpl.class);
        // factorableClasses.add(PartImpl.class);
        // factorableClasses.add(PortImpl.class);
        // factorableClasses.add(PortTypeImpl.class);
        // factorableClasses.add(ServiceImpl.class);
        // factorableClasses.add(TypesImpl.class);

        // types
        factorableClasses.add(TBindingImpl.class);
        factorableClasses.add(TAddressImpl.class);
        factorableClasses.add(TOperationImpl.class);
        factorableClasses.add(TBodyImpl.class);
        factorableClasses.add(THeaderImpl.class);
        factorableClasses.add(TFaultImpl.class);
        // factorableClasses.add(TBindingOperationFaultImpl.class);
        // factorableClasses.add(TBindingOperationImpl.class);
        // factorableClasses.add(TBindingOperationMessageImpl.class);
        // factorableClasses.add(TDefinitionsImpl.class);
        // factorableClasses.add(TDocumentationImpl.class);
        // factorableClasses.add(TFaultImpl.class);
        // factorableClasses.add(TImportImpl.class);
        // factorableClasses.add(TMessageImpl.class);
        // factorableClasses.add(TOperationImpl.class);
        // factorableClasses.add(TParamImpl.class);
        // factorableClasses.add(TPortImpl.class);
        // factorableClasses.add(TPortTypeImpl.class);
        // factorableClasses.add(TServiceImpl.class);
        // factorableClasses.add(TTypesImpl.class);

        // anonymous types

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }

    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject modelObject) throws InstantiationException,
            IllegalAccessException, InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, modelObject);
    }

}
