/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.esstar.management;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbWsdl;
import easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsrf.rp_2.EJaxbGetResourcePropertyResponse;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Ping;
import esstar.petalslink.com.data.management.user._1.PingResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import esstar.petalslink.com.service.management.user._1_0.UserManagement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

public class UserManagementClient
implements UserManagement {
    protected String address = null;
    private UserManagement clientProxy;
    private static ObjectFactory objectFactory = new ObjectFactory();

    public UserManagementClient(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    private synchronized UserManagement getClientProxy() {
        if (this.clientProxy != null) {
            return this.clientProxy;
        }
        this.clientProxy = (UserManagement)CXFHelper.getClient((String)this.address, UserManagement.class);
        return this.clientProxy;
    }

    public EJaxbSubscribeResponse subscribe(EJaxbSubscribe subscribeRequest) throws NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault, UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, UnrecognizedPolicyRequestFault, TopicNotSupportedFault, InvalidProducerPropertiesExpressionFault, ResourceUnknownFault, InvalidMessageContentExpressionFault {
        return this.getClientProxy().subscribe(subscribeRequest);
    }

    public EJaxbUnsubscribeResponse unsubscribe(EJaxbUnsubscribe unsubscribeRequest) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        return this.getClientProxy().unsubscribe(unsubscribeRequest);
    }

    public ProxifyResponse proxify(Proxify parameters) throws ManagementException {
        return this.getClientProxy().proxify(parameters);
    }

    public String expose(QName serviceName, String endpointName) throws ManagementException {
        return this.getClientProxy().expose(serviceName, endpointName);
    }

    public BindResponse bind(Bind parameters) throws ManagementException {
        return this.getClientProxy().bind(parameters);
    }

    public EJaxbGetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault, ResourceUnknownFault {
        return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
    }

    public String bind(String externalAddres, String wsdlUrl) throws ManagementException {
        Bind request = new Bind();
        request.setExternalAddress(externalAddres);
        EJaxbWsdl wsdl = new EJaxbWsdl();
        wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
        request.setWsdl(wsdl);
        BindResponse response = this.getClientProxy().bind(request);
        return response.getEndpointName();
    }

    public String proxify(String externalAddres, String wsdlUrl) throws ManagementException {
        Proxify request = new Proxify();
        request.setExternalAddress(externalAddres);
        EJaxbWsdl wsdl = new EJaxbWsdl();
        wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
        request.setWsdl(wsdl);
        ProxifyResponse response = this.getClientProxy().proxify(request);
        return response.getExternalAddress();
    }

    public EJaxbDeployementReport deploy(URL descriptorURL) throws ManagementException {
        if (descriptorURL == null) {
            throw new ManagementException("Descriptor file can not be null");
        }
        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorURL.toString());
        EJaxbDeploy request = new EJaxbDeploy();
        request.setMainResource(descriptor);
        EJaxbDeployResponse response = this.deploy(request);
        return response.getDeployementReport();
    }

    public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws ManagementException {
        if (descriptorFile == null) {
            throw new ManagementException("Descriptor file can not be null");
        }
        if (!descriptorFile.exists() || !descriptorFile.isFile()) {
            throw new ManagementException("Descriptor file " + descriptorFile.getName() + " does not exists or is not a file");
        }
        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorFile.toURI().toString());
        descriptor.setAttachment(new DataHandler((DataSource)new FileDataSource(descriptorFile)));
        ArrayList<EJaxbDescriptorType> list = new ArrayList<EJaxbDescriptorType>();
        if (resources != null) {
            for (File file : resources) {
                if (file == null || !file.exists() || !file.isFile()) continue;
                EJaxbDescriptorType resource = new EJaxbDescriptorType();
                resource.setFileURI(file.toURI().toString());
                resource.setAttachment(new DataHandler((DataSource)new FileDataSource(file)));
                list.add(resource);
            }
        }
        EJaxbDeploy request = new EJaxbDeploy();
        request.setMainResource(descriptor);
        request.getResources().addAll(list);
        EJaxbDeployResponse response = this.deploy(request);
        return response.getDeployementReport();
    }

    public void notify(EJaxbNotify notify) {
        this.getClientProxy().notify(notify);
    }

    public PingResponse ping(Ping parameters) throws ManagementException {
        PingResponse res = new PingResponse();
        return this.getClientProxy().ping(parameters);
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws ManagementException {
        return this.getClientProxy().deploy(parameters);
    }

    public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters) throws ManagementException {
        return this.getClientProxy().undeploy(parameters);
    }
}

