package com.ebmwebsourcing.esqml10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.esqml10.api.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "esqml10-impl";
    }    
    
    @Override
    public String getOriginatingSchemaDir() {
        return "schema/esqml10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "esqml10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.fr.upmc.ns.ws_qml.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.ESQML_NS_URI;
    }
    
    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.ESQML_NS_PREFERRED_PREFIX;
    }
    
        
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        // anonymous type
        factorableClasses.add(QoSDimensionImpl.class);
        factorableClasses.add(TypeImpl.class);
        factorableClasses.add(UnitImpl.class);
        factorableClasses.add(ValueImpl.class);
        
        // type
        factorableClasses.add(ConstraintTypeImpl.class);
        
        // element
        factorableClasses.add(ConstraintImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }

}
