package com.ebmwebsourcing.esqml10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.esqml10.api.anonymoustype.Value;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;

import easybox.fr.upmc.ns.ws_qml.EJaxbConstraintType;
import easybox.fr.upmc.ns.ws_qml.EJaxbValue;


class ConstraintTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbConstraintType> implements
ConstraintType {

	protected  ConstraintTypeImpl(XmlContext xmlContext, EJaxbConstraintType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbConstraintType> getCompliantModelClass() {
		return EJaxbConstraintType.class;
	}


	@Override
	public Value getValue() {
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getValue(), Value.class);
	}


	@Override
	public void setValue(Value value) {
		if(value != null) {
			getModelObject().setValue((EJaxbValue) ((AbstractJaxbXmlObjectImpl<?>) value).getModelObject());
		} else {
			getModelObject().setValue(null);
		}
	}


	@Override
	public boolean hasValue() {
		return this.getModelObject().getValue() != null;
	}


	@Override
	public String getOperator() {
		return this.getModelObject().getOperator();
	}


	@Override
	public void setOperator(String value) {
		this.getModelObject().setOperator(value);
	}


	@Override
	public boolean hasOperator() {
		return this.getModelObject().getOperator() != null;
	}


	@Override
	public String getName() {
		return this.getModelObject().getName();
	}


	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}


	@Override
	public boolean hasName() {
		return this.getName() != null;
	}

}
