package com.ebmwebsourcing.esqml10.impl;



import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.esqml10.api.anonymoustype.Type;
import com.ebmwebsourcing.esqml10.api.anonymoustype.Unit;
import com.ebmwebsourcing.esqml10.api.anonymoustype.Value;

import easybox.fr.upmc.ns.ws_qml.EJaxbType;
import easybox.fr.upmc.ns.ws_qml.EJaxbUnit;
import easybox.fr.upmc.ns.ws_qml.EJaxbValue;


final class ValueImpl extends AbstractJaxbXmlObjectImpl<EJaxbValue> implements
Value {

	protected ValueImpl(XmlContext xmlContext, EJaxbValue jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbValue> getCompliantModelClass() {
		return EJaxbValue.class;
	}


	@Override
	public Float getValue() {
		return this.getModelObject().getFloatValue();
	}


	@Override
	public void setValue(Float val) {
		this.getModelObject().setFloatValue(val);
	}


	@Override
	public boolean hasValue() {
		return this.getValue() != null;
	}


	@Override
	public Type getType() {
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getType(), Type.class);
	}


	@Override
	public void setType(Type t) {
		if(t != null) {
			getModelObject().setType((EJaxbType) ((AbstractJaxbXmlObjectImpl<?>) t).getModelObject());
		} else {
			getModelObject().setType(null);
		}
	}


	@Override
	public boolean hasType() {
		return this.getType() != null;
	}


	@Override
	public Unit getUnit() {
		return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getUnit(), Unit.class);
	}


	@Override
	public void setUnit(Unit unit) {
		if(unit != null) {
			getModelObject().setUnit((EJaxbUnit) ((AbstractJaxbXmlObjectImpl<?>) unit).getModelObject());
		} else {
			getModelObject().setUnit(null);
		}
	}


	@Override
	public boolean hasUnit() {
		return this.getUnit() != null;
	}



}
