/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.legacy.jaxb.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.xml.Transformers;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public final class SourceHelper {


	/**
	 * Creates a new instance of {@link SourceHelper}
	 * 
	 */
	private SourceHelper() {
		super();
	}


	public static InputSource convertDOMSource2InputSource(final DOMSource domSource)
	throws XmlException {
		InputSource source = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(os);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(domSource, streamResult);
            os.flush();
            os.close();
            InputStream is = new java.io.ByteArrayInputStream(os.toByteArray());

            StreamSource attach = new StreamSource(is);
            source = SAXSource.sourceToInputSource(attach);
        } catch (final IOException e) {
            throw new XmlException(e);
        } catch (TransformerException e) {
            throw new XmlException(e);
        } finally {
            if (transformer != null) {
                Transformers.releaseTransformer(transformer);
            }
        }
		     
		return source;
	}

	public static DOMSource convertInputSource2DOMSource(final InputSource inputSource)
	throws XmlException {
		DOMSource res = null;
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setNamespaceAware(true);
			DocumentBuilder db = factory.newDocumentBuilder();
			Document document = db.parse(inputSource);
			res = new DOMSource(document);
		} catch (final ParserConfigurationException e) {
			throw new XmlException(e);
		} catch (final SAXException e) {
			throw new XmlException(e);
		} catch (final IOException e) {
			throw new XmlException(e);
		}
		return res;
	}



	
}
