/****************************************************************************
 *
 * Copyright (c) 2008-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package com.ebmwebsourcing.wsstar.addressing.definition.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.EasyXMLFilter;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SchemaException;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.SourceHelper;
import com.ebmwebsourcing.wsstar.legacy.jaxb.core.XmlException;


/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class WSAddressingReaderImpl implements WSAddressingReader {

	private static Logger log = Logger.getLogger(WSAddressingReaderImpl.class.getName());

	private Map<FeatureConstants, Object> features = new HashMap<FeatureConstants, Object>();


	public WSAddressingReaderImpl() throws WSAddressingException {
		try {
			WSAddressingJAXBContext.createDefaultContext();
		} catch (final WSAddressingException e) {
			throw new WSAddressingException(e);
		}
	}

	public WSAddressingReaderImpl(final List<Class> addedObjectFactories)
	throws WSAddressingException {
		try {
			WSAddressingJAXBContext.createContextWithOtherObjectFactories(addedObjectFactories);
		} catch (final WSAddressingException e) {
			throw new WSAddressingException(e);
		}
	}

	private static com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType convertStream2EndpointReferenceType(
			final Source stream) throws WSAddressingException {

		try {
			// TODO : Check if it is a Thread safe method
			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> schemaBinding = WSAddressingReaderImpl
			.getJaxbContext().createUnmarshaller().unmarshal(stream,
					com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType.class);

			return schemaBinding.getValue();

		} catch (final JAXBException e) {
			throw new WSAddressingException(
					"Failed to build Java bindings from SchemaImpl descriptor XML document", e);
		}
	}


	/**
	 * @return the jaxbContext
	 */
	public static JAXBContext getJaxbContext() {
		return WSAddressingJAXBContext.getJaxbContext();
	}

	public EndpointReferenceType readEndpointReferenceType(final URI uri) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			InputStream input = null;
			final File f = new File(uri.getPath());
			if (f.exists()) {
				input = new FileInputStream(f);
			} else {
				input = uri.toURL().openStream();
			}
			desc = this.readEndpointReferenceType(uri, new InputSource(input));
		} catch (final MalformedURLException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final IOException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final SchemaException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		} catch (final XmlException e) {
			throw new WSAddressingException("Can not get wsdl at: " + uri, e);
		}
		return desc;
	}

	public EndpointReferenceType readEndpointReferenceType(final Document document) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			URI uri = new URI(".");
			if(document.getDocumentURI() != null) {
				uri = new URI(document.getDocumentURI());
			}
			desc = this.readEndpointReferenceType(uri, SourceHelper.convertDOMSource2InputSource(new DOMSource(
					document)));
		} catch (final URISyntaxException e) {
			throw new WSAddressingException(e);
		} catch (final XmlException e) {
			throw new WSAddressingException(e);
		}

		return desc;
	}

	public EndpointReferenceType readEndpointReferenceType(final URI uri, final InputSource source) throws WSAddressingException {
		EndpointReferenceType desc = null;
		try {
			final Unmarshaller unmarshaller = WSAddressingJAXBContext.getJaxbContext()
			.createUnmarshaller();

			final XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			final EasyXMLFilter filter = new EasyXMLFilter(xmlReader);
			final SAXSource saxSource = new SAXSource(filter, source);

			// TODO use SAX validation instead of JAXB validation
			// turn off the JAXB provider's default validation mechanism to
			// avoid duplicate validation
			// SchemaReaderImpl.getUnMarshaller().setValidating( false );

			final JAXBElement<com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType> eprBinding = unmarshaller.unmarshal(
					saxSource, com.ebmwebsourcing.wsstar.jaxb.addressing.EndpointReferenceType.class);


			desc = new EndpointReferenceTypeImpl(uri, eprBinding.getValue(), this.getFeatures());
		} catch (final XmlException e) {
			throw new WSAddressingException(e);
		} catch (final JAXBException e) {
			throw new WSAddressingException(e);
		} catch (final SAXException e) {
			throw new WSAddressingException(e);
		}

		return desc;
	}

	public void setFeature(final FeatureConstants name, final Object value)
	throws IllegalArgumentException {
		this.features.put(name, value);
		log.fine("set features: name = " + name + " - value = " + value);
	}

	public Object getFeature(final FeatureConstants name) throws IllegalArgumentException {
		return this.features.get(name);
	}

	public Map<FeatureConstants, Object> getFeatures() {
		return this.features;
	}

	public void setFeatures(final Map<FeatureConstants, Object> features) {
		this.features = features;
	}
	
	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingReader#readEndpointReferenceType(java.io.File)
	 */	 
	public EndpointReferenceType readEndpointReferenceType(File file) throws WSAddressingException {
		EndpointReferenceType result = null;		
		Document endpointRefAsDoc = this.convertFromFiletoDocument(file);
		result = this.readEndpointReferenceType(endpointRefAsDoc);
		return result;
	}
	
	 /**
     * convert xml File loaded as {@link File} Java object to {@link Document} Java object 
     * 
     * @param file {@lin File} Java object to convert
     * @return Document Representation 
     */
    private Document convertFromFiletoDocument(File file){
		Document result = null;		
		try{
			DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
			dbfac.setNamespaceAware(true);
			DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
			result = docBuilder.parse(file);
		} catch (SAXException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return result;
	}
}
