package com.ebmwebsourcing.wscap12.api.anonymoustype;

import java.util.Date;

import com.ebmwebsourcing.easybox.api.XmlObject;

public interface Info extends XmlObject {

	String getLanguage();
	void setLanguage(String value);
	boolean hasLanguage();

	String[] getCategories();
	void addCategory(String c);
	void removeCategory(String c);
	void clearCategories();

	String getEvent();
	void setEvent(String value);
	boolean hasEvent();

	String[] getResponseTypes();
	void addResponseType(String c);
	void removeResponseType(String c);
	void clearResponseTypes();

	String getUrgency();
	void setUrgency(String value);
	boolean hasUrgency();

	String getSeverity();
	void setSeverity(String value);
	boolean hasSeverity();

	String getCertainty();
	void setCertainty(String value);
	boolean hasCertainty();

	String getAudience();
	void setAudience(String value);
	boolean hasAudience();

	EventCode[] getEventCodes();
	void addEventCode(EventCode c);
	void removeEventCode(EventCode c);
	void clearEventCodes();
	EventCode getEventCodeByValueName(String name);

	Date getEffective();
	void setEffective(Date value);
	boolean hasEffective();

	Date getOnset();
	void setOnset(Date value);
	boolean hasOnset();

	Date getExpires();
	void setExpires(Date value);
	boolean hasExpires();

	String getSenderName();
	void setSenderName(String value);
	boolean hasSenderName();

	String getHeadline();
	void setHeadline(String value);
	boolean hasHeadline();

	String getDescription();
	void setDescription(String value);
	boolean hasDescription();

	String getInstruction();
	void setInstruction(String value);
	boolean hasInstruction();

	String getWeb();
	void setWeb(String value);
	boolean hasWeb();

	String getContact();
	void setContact(String value) ;
	boolean hasContact() ;

	Parameter[] getParameters();
	void addParameter(Parameter c);
	void removeParameter(Parameter c);
	void clearParameters();
	Parameter getParameterByValueName(String name);

	Resource[] getResources();
	void addResource(Resource c);
	void removeResource(Resource c);
	void clearResources();
	Resource getResourceByUri(String name);

}
