package com.ebmwebsourcing.wsdm10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.wsdm10.Constants;


// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/wsdm10";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "wsdm10.xsd";
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.oasis_open.docs.wsdm.mows_2.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.MOWS_NS_URI;
    }
    
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        // anoymous type
        
        // type
        factorableClasses.add(IntegerCounterImpl.class);
        factorableClasses.add(DurationMetricImpl.class);
        factorableClasses.add(OperationMetricTypeImpl.class);

        
        // element
        factorableClasses.add(LastRequestSizeImpl.class);
        factorableClasses.add(LastResponseSizeImpl.class);
        factorableClasses.add(LastResponseTimeImpl.class);
        factorableClasses.add(MaxRequestSizeImpl.class);
        factorableClasses.add(MaxResponseSizeImpl.class);
        factorableClasses.add(MaxResponseTimeImpl.class);
        factorableClasses.add(NumberOfFailedRequestImpl.class);
        factorableClasses.add(NumberOfRequestImpl.class);
        factorableClasses.add(NumberOfSuccessfulRequestImpl.class);
        factorableClasses.add(ServiceTimeImpl.class);
        factorableClasses.add(OperationMetricsImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }

	@Override
	public String getOriginatingSchemaPreferredNamespacePrefix() {
		return "wsdm";
	}

	@Override
	public String getName() {
		return "wsdm10-impl";
	}
}
