/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.bpel.command.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.bpel.behaviour.command.impl.BPELComponentCommandBehaviourImpl;
import com.ebmwebsourcing.easyesb.bpel.behaviour.observation.impl.BPELComponentObservationBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.ESBKernelFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.administration.GetProcessInstancesNames;
import com.ebmwebsourcing.easyviper.administration.GetProcessInstancesNamesResponse;
import com.ebmwebsourcing.easyviper.administration.IsProcessInstanceStarted;
import com.ebmwebsourcing.easyviper.administration.IsProcessInstanceStartedResponse;
import com.ebmwebsourcing.easyviper.administration.IsProcessInstanceStopped;
import com.ebmwebsourcing.easyviper.administration.IsProcessInstanceStoppedResponse;
import com.ebmwebsourcing.easyviper.administration.ObjectFactory;
import com.ebmwebsourcing.easyviper.administration.StopProcessInstance;
import com.ebmwebsourcing.easyviper.administration.StopProcessInstanceResponse;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpel;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BPELComponentCommandBehaviourTest {
    private EndpointInitialContext context = null;
    private ClientEndpoint clientEndpoint = null;
    private BPELComponent component = null;
    private Node node = null;
    private ObjectFactory factory = new ObjectFactory();

    public BPELComponentCommandBehaviourTest() throws Exception {
        this.context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, boolean explorer, String host, int port) throws ESBException {
        ESBKernelFactoryImpl factory = new ESBKernelFactoryImpl();
        ConfigurationImpl conf = new ConfigurationImpl(explorer, host, port, new ExternalServer[0]);
        conf.setRegistryServiceClass(RegistryServiceImpl.class);
        conf.setRegistryServiceBehaviourClass(RegistryServiceBehaviourImpl.class);
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    @Before
    public void setUp() {
        boolean explorer = false;
        try {
            this.node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), explorer, "localhost", 9001);
            this.component = (BPELComponent)((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).createComponent(new QName("http://com.ebmwebsourcing.easyesb", "BPELEngine"), BPELComponentImpl.class);
            this.component.addBehaviourClass(BPELComponentObservationBehaviourImpl.class);
            this.component.addBehaviourClass(BPELComponentBehaviourImpl.class);
            this.component.addBehaviourClass(BPELComponentCommandBehaviourImpl.class);
            this.clientEndpoint = ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://org.petalslink.easyesb/bpel/client", "myBPELComponentClient"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context);
            StoreBpel request = new StoreBpel();
            request.setBpelUrl(Thread.currentThread().getContextClassLoader().getResource("travelagency/process.bpel").toString());
            Exchange exchange = this.clientEndpoint.createExchange();
            exchange.setDestination(this.component.getQName());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://com.petalslink.easyesb/component/bpel/1.0", "storeBpel").toString());
            MessageUtil.getInstance().createInMessageStructure(exchange);
            exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)request));
            System.out.println("Exchange = " + exchange);
            Exchange response = this.clientEndpoint.sendSync(exchange, 0L);
        }
        catch (SOAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (ExchangeException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (TransportException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (ESBException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @After
    public void tearDown() {
        try {
            if (this.node != null) {
                this.node.stop();
            }
        }
        catch (TransportException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testStartStopProcess() {
        try {
            Exchange exchangeGetInstance = this.clientEndpoint.createExchange();
            exchangeGetInstance.setDestination(this.component.getQName());
            exchangeGetInstance.setPattern(PatternType.IN_OUT);
            exchangeGetInstance.setStatus(StatusType.ACTIVE);
            exchangeGetInstance.setOperation(new QName("http://ebmwebsourcing.com/easyviper/observation", "getProcessInstancesNames").toString());
            MessageUtil.getInstance().createInMessageStructure(exchangeGetInstance);
            GetProcessInstancesNames instanceIn = new GetProcessInstancesNames();
            instanceIn.setProcessDefinitionNameDataModel(new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelAgency"));
            exchangeGetInstance.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)instanceIn));
            Exchange responseGetInstances = this.clientEndpoint.sendSync(exchangeGetInstance, 0L);
            GetProcessInstancesNamesResponse res = (GetProcessInstancesNamesResponse)SOAJAXBContext.getInstance().marshallAnyType(responseGetInstances.getMessageOut().getBody().getPayload(), GetProcessInstancesNamesResponse.class);
            Exchange e = this.clientEndpoint.createExchange();
            e.setDestination(this.component.getQName());
            e.setPattern(PatternType.IN_OUT);
            e.setStatus(StatusType.ACTIVE);
            e.setOperation(new QName("http://ebmwebsourcing.com/easyviper/observation", "isProcessInstanceStarted").toString());
            MessageUtil.getInstance().createInMessageStructure(e);
            IsProcessInstanceStarted is = new IsProcessInstanceStarted();
            is.setIsProcessInstanceStartedInput((String)res.getProcessDefinitionName().get(0));
            e.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)is));
            Exchange eres = this.clientEndpoint.sendSync(e, 0L);
            IsProcessInstanceStartedResponse isres = (IsProcessInstanceStartedResponse)SOAJAXBContext.getInstance().marshallAnyType(eres.getMessageOut().getBody().getPayload(), IsProcessInstanceStartedResponse.class);
            Assert.assertTrue((boolean)isres.isIsProcessInstanceStartedOutputDataModel());
            Exchange exchange = this.clientEndpoint.createExchange();
            exchange.setDestination(this.component.getQName());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ebmwebsourcing.com/easyviper/command", "stopProcessInstance").toString());
            MessageUtil.getInstance().createInMessageStructure(exchange);
            StopProcessInstance in = new StopProcessInstance();
            String instanceName = (String)res.getProcessDefinitionName().get(0);
            System.out.println("INSTANCE NAME : " + instanceName);
            in.setStopProcessInstanceNameDataModel(instanceName);
            exchange.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)in));
            Exchange resStop = this.clientEndpoint.sendSync(exchange, 0L);
            StopProcessInstanceResponse ress = (StopProcessInstanceResponse)SOAJAXBContext.getInstance().marshallAnyType(resStop.getMessageOut().getBody().getPayload(), StopProcessInstanceResponse.class);
            Assert.assertNotNull((Object)ress);
            System.out.println(ress);
            Assert.assertNull((Object)resStop.getMessageError());
            Exchange exchangeIsStopped = this.clientEndpoint.createExchange();
            exchangeIsStopped.setDestination(this.component.getQName());
            exchangeIsStopped.setPattern(PatternType.IN_OUT);
            exchangeIsStopped.setStatus(StatusType.ACTIVE);
            exchangeIsStopped.setOperation(new QName("http://ebmwebsourcing.com/easyviper/observation", "isProcessInstanceStopped").toString());
            MessageUtil.getInstance().createInMessageStructure(exchangeIsStopped);
            IsProcessInstanceStopped isStopped = new IsProcessInstanceStopped();
            isStopped.setIsProcessInstanceStoppedInputDataModel(instanceName);
            exchangeIsStopped.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)isStopped));
            Exchange exchangeIsStoppedResponse = this.clientEndpoint.sendSync(exchangeIsStopped, 0L);
            IsProcessInstanceStoppedResponse isStoppedResponse = (IsProcessInstanceStoppedResponse)SOAJAXBContext.getInstance().marshallAnyType(exchangeIsStoppedResponse.getMessageOut().getBody().getPayload(), IsProcessInstanceStoppedResponse.class);
            Assert.assertTrue((boolean)isStoppedResponse.isIsProcessInstanceStoppedOutputDataModel());
            Exchange exchange2 = this.clientEndpoint.createExchange();
            exchange2.setDestination(this.component.getQName());
            exchange2.setPattern(PatternType.IN_OUT);
            exchange2.setStatus(StatusType.ACTIVE);
            exchange2.setOperation(new QName("http://ebmwebsourcing.com/easyviper/command", "stopProcessInstance").toString());
            MessageUtil.getInstance().createInMessageStructure(exchange2);
            in.setStopProcessInstanceNameDataModel("{http://}wrongName_12");
            exchange2.getMessageIn().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)in));
            Exchange resStop2 = this.clientEndpoint.sendSync(exchange2, 0L);
            Assert.assertNotNull((Object)resStop2.getMessageError());
            System.out.println(resStop2.getMessageError());
            Assert.assertNull((Object)resStop2.getMessageOut());
        }
        catch (ExchangeException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (SOAException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (TransportException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

