/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.cep.server;

import com.ebmwebsourcing.cep.server.Cep;
import com.ebmwebsourcing.cep.server.mock.MockEventCloud;
import com.ebmwebsourcing.easiergov.WSContainer;
import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easycommons.research.util.cxf.Server;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.seacloud.client.SeaCloudClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.petalslink.data_api._1.PublishSchema;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import engine.cep.admin.api.Action;
import engine.cep.admin.api.AddStatementResponseWithActions;
import engine.cep.admin.api.AddStatementWithActions;
import engine.cep.admin.api.Namespace;
import engine.cep.admin.api.SubscriptionsRequired;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import seacloud.petalslink.com.data._1.AddResourcesDescriptor;
import seacloud.petalslink.com.data._1.Resource;
import seacloud.petalslink.com.data._1.ResourceType;
import seacloud.petalslink.com.data._1.ResourcesDescriptor;
import seacloud.petalslink.com.service.management.cloud._1_0.CloudManagementException;

public class CepTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startServer() throws CloudManagementException {
        Cep adminCloud = null;
        try {
            adminCloud = new Cep("http://localhost:9666/Cep");
            adminCloud.start();
            System.out.println("coucou");
        }
        finally {
            if (adminCloud != null) {
                adminCloud.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addStatementWithActionsUsingEsperModuleTest() throws Exception {
        Cep cep = null;
        try {
            MockEventCloud eventcloud = new MockEventCloud();
            Server eventCloudServer = CXFHelper.getService((String)"http://localhost:9750/eventCloud", eventcloud.getClass(), (Object)eventcloud);
            eventCloudServer.start();
            WSContainer easiergov = new WSContainer((Configuration)new ConfigurationImpl("localhost", 9738, 9739));
            easiergov.start();
            DataManagerClientImplSOAP easierGovClient = new DataManagerClientImplSOAP("http://localhost:9738/services/dataManager");
            PublishSchema publishRequest = new PublishSchema();
            publishRequest.setXsdUrl(Thread.currentThread().getContextClassLoader().getResource("eventGlobal.xsd").toURI().toString());
            easierGovClient.publishSchema(publishRequest);
            cep = new Cep("http://localhost:9666/Cep");
            cep.start();
            SeaCloudClientSOAP seaCloudClient = new SeaCloudClientSOAP("http://localhost:9666/Cep");
            ResourcesDescriptor descriptor = new ResourcesDescriptor();
            Resource govNode = new Resource();
            govNode.setAddress("http://localhost:9738/services/eventManager");
            govNode.setType(ResourceType.GOVERNANCE);
            descriptor.getResource().add(govNode);
            AddResourcesDescriptor request = new AddResourcesDescriptor();
            request.setResourcesDescriptor(descriptor);
            seaCloudClient.addResourcesDescriptor(request);
            AddStatementWithActions req = new AddStatementWithActions();
            req.setStatementId(UUID.randomUUID().toString());
            req.setStatement("select * from offerEvent.win:keepall() as driverOffer, offerEvent.win:keepall() as truckOffer, demandEvent.win:keepall() as driverDemand, demandEvent.win:keepall() as truckDemand where driverOffer.resources.type='driver' and truckOffer.resources.type='truck' and driverDemand.resources.type='driver' and truckDemand.resources.type='truck' and driverDemand.resources.quantity<=driverOffer.resources.quantity and truckDemand.resources.quantity<=truckOffer.resources.quantity");
            ArrayList<Namespace> namespaceOfEventTypes = new ArrayList<Namespace>();
            Namespace nsOfferEvent = new Namespace();
            nsOfferEvent.setPrefix("data");
            nsOfferEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
            nsOfferEvent.setEventTypeName("offerEvent");
            namespaceOfEventTypes.add(nsOfferEvent);
            Namespace nsDemandEvent = new Namespace();
            nsDemandEvent.setPrefix("data");
            nsDemandEvent.setNamespace("http://www.mines-albi.fr/nuclearcrisisevent");
            nsDemandEvent.setEventTypeName("demandEvent");
            namespaceOfEventTypes.add(nsDemandEvent);
            req.getNamespaceOfEventTypes().addAll(namespaceOfEventTypes);
            Action a = new Action();
            a.setName(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "resourcesStatusEvent"));
            a.setType("event");
            a.getPublishDestination().add("http://localhost:9750/eventCloud");
            a.getTopic().add(new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "s"));
            a.setFields(new Action.Fields());
            Action.Fields.Entry e1 = new Action.Fields.Entry();
            e1.setKey("$output/data:resources/data:quantity");
            e1.setValue("$driverOffer/data:resources/data:quantity");
            a.getFields().getEntry().add(e1);
            Action.Fields.Entry e2 = new Action.Fields.Entry();
            e2.setKey("$output/data:provider");
            e2.setValue("$driverOffer/data:provider");
            a.getFields().getEntry().add(e2);
            req.getAction().add(a);
            SubscriptionsRequired required = new SubscriptionsRequired();
            SubscriptionsRequired.Entry erDemandEvent = new SubscriptionsRequired.Entry();
            erDemandEvent.setEndpointAddressToSubscribe("http://localhost:9750/eventCloud");
            erDemandEvent.setTopic(new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"));
            erDemandEvent.setCorrespondingEvent(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "demandEvent"));
            required.getEntry().add(erDemandEvent);
            SubscriptionsRequired.Entry erOfferEvent = new SubscriptionsRequired.Entry();
            erOfferEvent.setEndpointAddressToSubscribe("http://localhost:9750/eventCloud");
            erOfferEvent.setTopic(new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic"));
            erOfferEvent.setCorrespondingEvent(new QName("http://www.mines-albi.fr/nuclearcrisisevent", "offerEvent"));
            required.getEntry().add(erOfferEvent);
            req.setSubscriptionsRequired(required);
            AddStatementResponseWithActions res = seaCloudClient.addStatementWithActions(req);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((int)2, (int)eventcloud.getCptInvocation());
            String oe1msg = "      <ns27:offerEvent xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>e1372251-70c2-463b-820c-c5124072f635</ns27:uid>\r\n        <ns27:provider>bus</ns27:provider>\r\n        <ns27:resources>\r\n          <ns27:type>truck</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:offerEvent>";
            Document oe1 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(oe1msg.getBytes()));
            Notify notifyOe1 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)oe1);
            seaCloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyOe1));
            String oe2msg = "      <ns27:offerEvent xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\">\r\n            <ns27:uid>aea63eba-795c-45ca-a57b-4f01c41736f1</ns27:uid>\r\n            <ns27:provider>car</ns27:provider>\r\n            <ns27:resources>\r\n              <ns27:type>driver</ns27:type>\r\n              <ns27:quantity>5.0</ns27:quantity>\r\n            </ns27:resources>\r\n          </ns27:offerEvent>";
            Document oe2 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(oe2msg.getBytes()));
            Notify notifyOe2 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)oe2);
            seaCloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyOe2));
            String de2msg = "      <ns27:demandEvent xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>3bef76d3-9dd1-4c43-a250-47e671ad9844</ns27:uid>\r\n        <ns27:resources>\r\n          <ns27:type>driver</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:demandEvent>";
            Document de2 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(de2msg.getBytes()));
            Notify notifyDe2 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)de2);
            seaCloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyDe2));
            String de1msg = "      <ns27:demandEvent xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:ns27=\"http://www.mines-albi.fr/nuclearcrisisevent\" >\r\n        <ns27:uid>3bef76d3-9dd1-4c43-a250-47e671ad9844</ns27:uid>\r\n        <ns27:resources>\r\n          <ns27:type>truck</ns27:type>\r\n          <ns27:quantity>5.0</ns27:quantity>\r\n        </ns27:resources>\r\n      </ns27:demandEvent>";
            Document de1 = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(de1msg.getBytes()));
            Notify notifyDe1 = WSNHelper.createNotification((String)"http://localhost:9750/eventCloud", (String)"http://subscriptionProducer.com/", (QName)new QName("http://www.petalslink.org/EventCloud/", "resourcesEventTopic", "evt"), (Object)de1);
            seaCloudClient.notify(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notifyDe1));
            while (eventcloud.getCptNotification() == 0) {
                Thread.sleep(200L);
            }
            Assert.assertEquals((int)1, (int)eventcloud.getCptNotification());
        }
        finally {
            if (cep != null) {
                cep.stop();
            }
        }
    }
}

