/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.process.test.util;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.petalslink.easiersbs.matching.process.util.BpmnUtil;
import com.petalslink.easiersbs.matching.service.api.profile.SearchPart;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class BpmnUtilTest {
    private static final String BPMN_URL = "simple/Sabpmn.xml";
    private URL simpleBpmnUrl = Thread.currentThread().getContextClassLoader().getResource("simple/Sabpmn.xml");
    private Definitions simpleSabpmn;

    @Before
    public void setUp() throws XmlObjectReadException {
        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        XmlContext xmlContext = xmlContextFactory.newContext();
        XmlObjectReader reader = xmlContext.createReader();
        this.simpleSabpmn = (Definitions)reader.readDocument(this.simpleBpmnUrl, Definitions.class);
    }

    @Test
    public void testExtractTasks() {
        Set tasks = BpmnUtil.extractTasks((Definitions)this.simpleSabpmn);
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((int)3, (int)tasks.size());
        boolean res = false;
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            if (!((Task)it.next()).getId().equals("servicetaskId")) continue;
            res = true;
        }
        Assert.assertTrue((boolean)res);
    }

    @Test
    public void testExtractSearchProfile() {
        Set tasks = BpmnUtil.extractTasks((Definitions)this.simpleSabpmn);
        Task targetTask = null;
        for (Task task : tasks) {
            if (!task.getId().equals("servicetaskId")) continue;
            targetTask = task;
            break;
        }
        Assert.assertNotNull(targetTask);
        SearchProfile profile = BpmnUtil.extractSearchProfile(targetTask);
        Assert.assertNotNull((Object)profile);
        Assert.assertEquals((int)0, (int)((SearchPart)profile.getSemanticInterface()).getSemanticConcepts().size());
        Assert.assertEquals((int)2, (int)((SearchPart)profile.getSemanticOperation()).getSemanticConcepts().size());
        Assert.assertEquals((int)3, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getInputSemanticElement()).size());
        Assert.assertEquals((int)1, (int)ServiceUtil.getFlattenElements((GenericElement)profile.getOutputSemanticElement()).size());
    }
}

