/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.process.matcher;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.petalslink.easiersbs.matching.message.api.MessageMatchingRegistryManager;
import com.petalslink.easiersbs.matching.message.api.matcher.MessageMatcher;
import com.petalslink.easiersbs.matching.message.api.model.MessageTransformation;
import com.petalslink.easiersbs.matching.message.matcher.MessageMatcherImpl;
import com.petalslink.easiersbs.matching.process.api.matcher.MessageProcessMatcher;
import com.petalslink.easiersbs.matching.process.util.BpmnUtil;
import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class MessageProcessMatcherImpl implements MessageProcessMatcher {

	MessageMatcher matcher = null;
	
	public MessageProcessMatcherImpl(MessageMatchingRegistryManager manager, ReasonerFactory factory, MatcherProperties props) throws ReasonerException{
		this.matcher = new MessageMatcherImpl(manager, factory, props);
	}
	
	public MessageProcessMatcherImpl(MessageMatcher matcher){
		this.matcher = matcher;
	}

	public Set<MessageTransformation> computeAllProcessTransformations(
			Definitions bpmn) throws BPMNException, EasierSBSException, ReasonerException {
		
		Set<MessageTransformation> res = new HashSet<MessageTransformation>();
		
		for(Task task : BpmnUtil.extractTasks(bpmn)){
			if(task.getIncomingFlowNodes() != null
					&& task.getIncomingFlowNodes().size() != 0){
				res.add(matcher.computeMessageTransformation(bpmn, task));
			}
		}

		return res;
	}


	public void integrateTransformationsIntoBpmnProcess(Set<MessageTransformation> transformations) 
							throws BPMNException {
		
		for(MessageTransformation transformation : transformations){
			Task targetTask = transformation.getTargetTask();
			
			List<DataInputAssociation> dias = transformation.generateDataInputAssociations();
			for(DataInputAssociation dia : dias){
				targetTask.addDataInputAssociation(dia);
			}
		}
	}

}
