/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.process.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Task;
import com.ebmwebsourcing.geasywsdl.domain.api.IDefinitions;
import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;
import com.ebmwebsourcing.geasywsdl.service.serverToClient.DefinitionsParser;
import com.petalslink.easiersbs.matching.process.api.matcher.ServiceProcessMatcher;
import com.petalslink.easiersbs.matching.process.api.model.RatedOperation;
import com.petalslink.easiersbs.matching.process.model.RatedOperationImpl;
import com.petalslink.easiersbs.matching.process.util.BpmnUtil;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.rated.RatedSemanticProfile;
import com.petalslink.easiersbs.registry.service.api.RegistryException;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Operation;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ServiceProcessMatcherImpl implements ServiceProcessMatcher {

	private HybridMatcher serviceMatcher;
	
	public ServiceProcessMatcherImpl(HybridMatcher serviceMatcher){
		this.serviceMatcher = serviceMatcher;
	}
	
	public Map<Task, Set<RatedSemanticProfile>> computeAllServiceMatching(Definitions bpmn) {
		
		Map<Task, Set<RatedSemanticProfile>> res = new HashMap<Task, Set<RatedSemanticProfile>>();
		
		for(Task task : BpmnUtil.extractTasks(bpmn)){
			SearchProfile profile = BpmnUtil.extractSearchProfile(task);
			MatchingResult matching = serviceMatcher.findServices(profile);
			res.put(task, matching.getResultProfiles());
		}
		
		return res;
	}


	public Map<String, Set<RatedOperation>> prepareResult(Map<Task, Set<RatedSemanticProfile>> results) throws RegistryException {
		Map<String, Set<RatedOperation>> res = new HashMap<String, Set<RatedOperation>>();
		
		SemanticRegistryManager registry = serviceMatcher.getSemanticRegistryManager();
		DefinitionsParser parser = new DefinitionsParser();
		
		for(Entry<Task, Set<RatedSemanticProfile>> result : results.entrySet()){
			String taskId = result.getKey().getId();
			Set<RatedOperation> ratedOperations = new HashSet<RatedOperation>();
			
			for(RatedSemanticProfile ratedProfile : result.getValue()){
				//Operation generation
				SemanticProfile profile = ratedProfile.getProfile();
				List<IOperation> ops = new ArrayList<IOperation>();
				QName serviceQName = null;
				for(Operation profileOp : profile.getOperations()){
					serviceQName = profileOp.getServiceQName();
					Description desc = registry.getTechnicalService(serviceQName);
					IDefinitions def = parser.parseDefinitions(desc);
				
					IOperation op = this.findOperation(def, profileOp.getOperationQName());
					ops.add(op);
				}
				// Bidouille pourrie
				RatedOperation ratedOp = new RatedOperationImpl(ops, ratedProfile.getProfileRate(), 
						serviceQName.getNamespaceURI(), serviceQName.getLocalPart());
				ratedOperations.add(ratedOp);
			}
			
			res.put(taskId, ratedOperations);
			
		}
		
		return res;
	}
	
	private IOperation findOperation(IDefinitions def, QName operationQName){
		Iterator<IPortType> itPortType = def.getPortTypes().iterator();
		while(itPortType.hasNext()){
			IPortType portType = itPortType.next();
			Iterator<IOperation> itOperation = portType.getOperations().iterator();
			while(itOperation.hasNext()){
				IOperation op = itOperation.next();
				if(op.getName().equals(operationQName.getLocalPart())){
					return op;
				}
			}
		}
		return null;
	}

}
