/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.process.model;

import java.io.Serializable;
import java.util.List;

import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.petalslink.easiersbs.matching.process.api.model.RatedOperation;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class RatedOperationImpl implements RatedOperation, Serializable {

	private static final long serialVersionUID = 1464868757212631910L;
	
	private double rate = 0;
	private String serviceLocalName;
	private String serviceNamespace;
	private List<IOperation> ops;
	
	public RatedOperationImpl(){
		super();
	}
	
	public RatedOperationImpl(List<IOperation> ops, double rate, String serviceNamespace, String serviceLocalName){
		super();
		this.ops = ops;
		this.rate = rate;
		this.serviceNamespace = serviceNamespace;
		this.serviceLocalName = serviceLocalName;
	}
	
	public double getRate() {
		return rate;
	}

	public void setRate(double rate) {
		this.rate = rate;
	}
	
	public List<IOperation> getIndivitualOperations() {
		return ops;
	}

	public void setIndivitualOperations(List<IOperation> ops) {
		this.ops = ops;
	}

	public String getServiceLocalName() {
		return serviceLocalName;
	}

	public void setServiceLocalName(String localName) {
		this.serviceLocalName = localName;
	}

	public String getServiceNamespace() {
		return serviceNamespace;
	}

	public void setServiceNamespace(String namespace) {
		this.serviceNamespace = namespace;
	}

}
