/*
 * Decompiled with CFR 0.152.
 */
package petals.ow2.org.demo.travelagency.agency;

import com.ebmwebsourcing.easiestdemo.helper.BusManagement;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import petals.ow2.org.demo.travelagency.airline.AirLineBookService_WSOUIServer;
import petals.ow2.org.demo.travelagency.car.CarService_WSOUIServer;
import petals.ow2.org.demo.travelagency.hotel.Hotel_WSOUIServer;

public class Travelagency_Main {
    public static final URL BPEL_LOCATION = Thread.currentThread().getContextClassLoader().getResource("travelagency.bpel");
    private AirLineBookService_WSOUIServer airLineBookService_WSOUIServer = null;
    private Hotel_WSOUIServer hotel_WSOUIServer = null;
    private CarService_WSOUIServer carService_WSOUIServer = null;
    private Node node = null;
    private QName nodeName = new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelagency_EasyESBNode");
    private String nodeHost = "localhost";
    private int nodeInternalPort = 8000;
    private int nodeSoapPort = 8085;
    private String adminUrl = "http://" + this.nodeHost + ":" + this.nodeSoapPort + "/services/adminExternalEndpoint";
    private static boolean standalone;

    public static void main(String[] args) throws Exception {
        Travelagency_Main main = new Travelagency_Main();
        PrintStream err = System.err;
        try {
            boolean activeGUI = true;
            Travelagency_Main.analyzeCommand(args);
            main.startAllWebServices();
            main.setGUIOnAllWebServices(activeGUI);
            main.createNode();
            List<URL> bpelUrls = main.deployAndExposeBPEL(BPEL_LOCATION);
            if (activeGUI) {
                main.createClient();
            }
            Scanner sc = new Scanner(System.in);
            System.out.println("Hit Enter to exit :");
            sc.nextLine();
        }
        catch (Exception e) {
            e.printStackTrace(err);
            main.stopAllWebServices();
            main.stopNode();
        }
    }

    public static void analyzeCommand(String[] args) {
        if (args != null && args.length == 1 && args[0].equals("standalone")) {
            standalone = true;
        }
    }

    public boolean isStandalone() {
        return standalone;
    }

    public void createNode() throws ESBException {
        this.node = BusManagement.getInstance().createNode(this.nodeName, this.nodeHost, this.nodeInternalPort, this.nodeSoapPort);
    }

    public List<URL> deployAndExposeBPEL(URL bpel) throws MalformedURLException, ManagementException {
        List urls = BusManagement.getInstance().deployAndExposeBPEL(bpel, new URL(this.adminUrl));
        System.out.println("BPEL " + bpel + " are exposed at url:");
        for (URL url : urls) {
            System.out.println("\t" + url);
        }
        return urls;
    }

    public void stopNode() throws TransportException {
        this.node.stop();
    }

    public void startAllWebServices() throws WSOUIException {
        if (!this.isStandalone()) {
            this.airLineBookService_WSOUIServer = new AirLineBookService_WSOUIServer();
            this.airLineBookService_WSOUIServer.start();
            this.hotel_WSOUIServer = new Hotel_WSOUIServer();
            this.hotel_WSOUIServer.start();
            this.carService_WSOUIServer = new CarService_WSOUIServer();
            this.carService_WSOUIServer.start();
        }
    }

    public void createClient() throws WSOUIException {
        try {
            WSOUIClient client = new WSOUIClient();
            org.petalslink.easiestdemo.client.model.api.esb.Node n = client.addNewAdminWsdlofESBNode(new URL[]{new URL(this.adminUrl + "?wsdl")});
            n.setModel(this.node);
            client.setVisible(true);
        }
        catch (MalformedURLException e) {
            throw new WSOUIException((Throwable)e);
        }
        catch (WSOUIClientException e) {
            throw new WSOUIException((Throwable)e);
        }
    }

    public void setGUIOnAllWebServices(boolean activeGUI) throws WSOUIException {
        if (!this.isStandalone()) {
            if (this.airLineBookService_WSOUIServer != null) {
                this.airLineBookService_WSOUIServer.getProviderConfigurationFor_AirLineBookService().setActiveGui(activeGUI);
            }
            if (this.hotel_WSOUIServer != null) {
                this.hotel_WSOUIServer.getProviderConfigurationFor_Hotel().setActiveGui(activeGUI);
            }
            if (this.carService_WSOUIServer != null) {
                this.carService_WSOUIServer.getProviderConfigurationFor_CarService().setActiveGui(activeGUI);
            }
        }
    }

    public void stopAllWebServices() {
        if (!this.isStandalone()) {
            if (this.airLineBookService_WSOUIServer != null) {
                this.airLineBookService_WSOUIServer.stop();
            }
            if (this.hotel_WSOUIServer != null) {
                this.hotel_WSOUIServer.stop();
            }
            if (this.carService_WSOUIServer != null) {
                this.carService_WSOUIServer.stop();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("logger/easiestdemo-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (Exception ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
        standalone = false;
    }
}

