/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.test;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.Arrays;
import com.ebmwebsourcing.easyesb.cli.impl.BindCommand;
import com.ebmwebsourcing.easyesb.cli.impl.CommandReader;
import com.ebmwebsourcing.easyesb.cli.impl.ConfParserCommand;
import com.ebmwebsourcing.easyesb.cli.impl.Connectcommand;
import com.ebmwebsourcing.easyesb.cli.impl.ESBClientLauncher;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.test.Echo_EchoSOAP_Server;
import com.ebmwebsourcing.easyesb.ws.weather.Weather_WeatherSOAP_Server;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CommandsTest {
    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        });
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImport() {
        Node n = null;
        Echo_EchoSOAP_Server echoServer = null;
        Connectcommand cc = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9000, 8100);
            String serviceAddress = "http://localhost:8100/services/adminExternalEndpoint";
            echoServer = new Echo_EchoSOAP_Server();
            String echoURL = "http://localhost:9001/echo";
            CommandReader cr = new CommandReader();
            cc = new Connectcommand(cr);
            cc.process(Arrays.asList((Object[])new String[]{serviceAddress}));
            Assert.assertEquals((int)1, (int)cc.getResultCode());
            BindCommand impCommand = new BindCommand();
            impCommand.process(Arrays.asList((Object[])new String[]{echoURL, echoURL + "?wsdl"}));
            Assert.assertEquals((int)1, (int)impCommand.getResultCode());
            System.out.println(impCommand.getResult());
            Assert.assertEquals((String)"esb://http://ws.easyesb.ebmwebsourcing.com/echo/::echo@echoSOAP?type=ProviderProxyEndpoint", (String)impCommand.getResult());
        }
        catch (ESBException e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (echoServer != null) {
                echoServer.shutdown();
            }
            if (cc != null) {
                cc.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfScript() {
        Node n = null;
        Node n2 = null;
        Echo_EchoSOAP_Server echoServer = null;
        Weather_WeatherSOAP_Server weatherServer = null;
        ConfParserCommand conf = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9001, 8101);
            n2 = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9002, 8102);
            echoServer = new Echo_EchoSOAP_Server();
            String echoURL = "http://localhost:9001/echo";
            String weatherURL = "http://localhost:9002/weather";
            weatherServer = new Weather_WeatherSOAP_Server(weatherURL);
            CommandReader cr = new CommandReader();
            conf = new ConfParserCommand(cr);
            String arg = Thread.currentThread().getContextClassLoader().getResource("testConfScript.xml").getPath();
            conf.process(Arrays.asList((Object[])new String[]{arg}));
            Assert.assertEquals((int)1, (int)conf.getResultCode());
            System.out.println(conf.getResult());
            Assert.assertEquals((String)"Proxify : http://localhost:8101/services/WeatherSOAPClientProxyEndpoint\nDeploy : deployment ok travelagency.bpel\nBind result: esb://http://ws.easyesb.ebmwebsourcing.com/echo/::echo@echoSOAP?type=ProviderProxyEndpoint\nAddNeighbourNode : New neighbours (1)http://localhost:8102/services/adminExternalEndpoint and (2)http://localhost:8101/services/adminExternalEndpoint\nExpose result : http://localhost:8102/services/echoSOAPClientProxyEndpoint", (String)conf.getResult());
            Assert.assertEquals((int)1, (int)((NodeBehaviour)n2.findBehaviour(NodeBehaviour.class)).getInformations().getRegistry().getNeighbourNode().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getLocalizedMessage());
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (n2 != null) {
                try {
                    n2.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (echoServer != null) {
                echoServer.shutdown();
            }
            if (weatherServer != null) {
                weatherServer.stop();
            }
            if (conf != null) {
                conf.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testCLICommandOff() {
        Node n = null;
        Echo_EchoSOAP_Server echoServer = null;
        try {
            n = this.createNode(new QName("http://easyesb", "testImportNode"), "localhost", 9001, 8101);
            echoServer = new Echo_EchoSOAP_Server();
            String echoURL = "http://localhost:9001/echo";
            ESBClientLauncher launcher = new ESBClientLauncher();
            String[] args = new String[]{"start", "c", "http://localhost:8101/services/adminExternalEndpoint", "i", "http://localhost:9001/echo", "http://localhost:9001/echo?wsdl"};
            launcher.setSystemExitHook(null);
            launcher.launch(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            if (n != null) {
                try {
                    n.stop();
                }
                catch (TransportException e) {
                    e.printStackTrace();
                }
            }
            if (echoServer != null) {
                echoServer.shutdown();
            }
        }
    }
}

