/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import java.util.List;

public class BindCommand
extends AbstractCommand {
    private String url;
    private String wsdl;

    public BindCommand() {
        this.setName("Bind");
        this.setDescription("Bind WS to node");
        this.setShortcut("b");
    }

    @Override
    public void execute() {
        try {
            String res = this.getClient().bind(this.url, this.wsdl);
            this.setResult(res);
            this.resultCode = 1;
        }
        catch (Throwable e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.url = args.get(0);
        this.wsdl = args.get(1);
        this.execute();
        return this.resultCode;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        return args.size() == 2;
    }

    public String toString() {
        return "b <url> <wsdl> \t\t\t\t\t{Bind/Import Web Service (SOAP) in the ESB node}";
    }
}

