/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AddNeighbourNodeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.BindCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ConfParserCommand;
import com.ebmwebsourcing.easyesb.cli.impl.Connectcommand;
import com.ebmwebsourcing.easyesb.cli.impl.DeployCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ExportCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ExposeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ProxifyCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CommandReader {
    protected File currentPath;
    SortedMap<String, Command> map = new TreeMap<String, Command>();
    private String host;
    private List<String> history;
    private static final String NOCONNECTION = "no-connection";

    public CommandReader() {
        this.addCommand(new Connectcommand(this));
        this.addCommand(new ConfParserCommand(this));
        this.addCommand(new ExportCommand(this));
        this.addCommand(new BindCommand());
        this.addCommand(new ExposeCommand());
        this.addCommand(new ProxifyCommand());
        this.addCommand(new DeployCommand());
        this.addCommand(new AddNeighbourNodeCommand());
        this.host = NOCONNECTION;
        this.history = new ArrayList<String>();
    }

    private void addCommand(Command command) {
        this.map.put(command.getShortcut(), command);
    }

    public void read() {
        System.out.println("ESB Client prompt. Tape 'h' for help.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int code = 1;
        while (code > 0) {
            try {
                System.out.println();
                System.out.print("esb-client@" + this.host + ":/> ");
                code = this.processCommandLine(br.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected int processCommandLine(String command) {
        int result = 1;
        if (command != null && command.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(command, " ");
            ArrayList<String> args = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                args.add(tokenizer.nextToken());
            }
            String key = (String)args.get(0);
            if ("h".equalsIgnoreCase(key) || "help".equalsIgnoreCase(key)) {
                this.printUsage();
            } else if ("x".equalsIgnoreCase(key) || "quit".equalsIgnoreCase(key)) {
                System.exit(0);
            } else {
                Command task = this.getTask(key);
                if (task == null) {
                    System.out.println("Unrecognized command : " + command + " (type 'h' for help)");
                } else {
                    List arguments = null;
                    arguments = args.size() > 1 ? args.subList(1, args.size()) : new ArrayList(0);
                    result = task.process(arguments);
                    if (result == -2) {
                        System.out.println("Bad arguments : " + arguments + " (type 'h' for help)");
                    } else if (result == -3) {
                        System.out.println("No connection ... Connect first to a esb node with Connect (c) command.");
                    } else if (result == -1) {
                        System.out.println("Error while executing command " + command);
                    } else {
                        this.getHistory().add(command);
                    }
                    result = 1;
                }
            }
        }
        return result;
    }

    public List<String> getHistory() {
        return this.history;
    }

    public void resetHistory() {
        this.history.clear();
    }

    private void printUsage() {
        System.out.println("ESB Client prompt usage:");
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Command command = (Command)this.map.get(iter.next());
            System.out.println(" - " + command.toString());
        }
    }

    private Command getTask(String command) {
        String shortcut;
        Command task = (Command)this.map.get(command);
        if (task == null && (shortcut = this.getShortcutFromCommand(command)) != null) {
            task = (Command)this.map.get(shortcut);
        }
        return task;
    }

    private String getShortcutFromCommand(String command) {
        String result = null;
        boolean found = false;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext() && !found) {
            Command task = (Command)this.map.get(iter.next());
            if (!command.equals(task.getName())) continue;
            result = task.getShortcut();
            found = true;
        }
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

