/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.api.Command;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.AddNeighbourNodeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.BindCommand;
import com.ebmwebsourcing.easyesb.cli.impl.CommandReader;
import com.ebmwebsourcing.easyesb.cli.impl.Connectcommand;
import com.ebmwebsourcing.easyesb.cli.impl.DeployCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ExposeCommand;
import com.ebmwebsourcing.easyesb.cli.impl.ProxifyCommand;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ConfParserCommand
extends AbstractCommand {
    private File confFile;
    private CommandReader cr;

    public ConfParserCommand(CommandReader cr) {
        this.setName("ConfParser");
        this.setDescription("Parse a XML Configuration file to execute administration commands.");
        this.setShortcut("p");
        this.cr = cr;
        this.setResult("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            if (this.confFile != null && this.confFile.exists()) {
                SAXBuilder builder = new SAXBuilder(false);
                Document jdom = builder.build(this.confFile);
                Element element = jdom.getRootElement();
                List servicesChildren = element.getChildren("Service", Command.NAMESPACE_JDOM);
                for (int i = 0; i < servicesChildren.size(); ++i) {
                    Element e = (Element)servicesChildren.get(i);
                    this.parseService(e);
                }
                this.resultCode = 1;
            }
        }
        catch (JDOMException e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
        catch (IOException e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
        finally {
            this.reset();
        }
    }

    private void parseService(Element e) {
        ArrayList<String> address = new ArrayList<String>();
        address.add(e.getAttributeValue("url"));
        try {
            Connectcommand connect = new Connectcommand(this.cr);
            int cres = connect.process(address);
            if (cres != 1) {
                this.resultCode = cres;
                return;
            }
        }
        catch (RuntimeException ex) {
            this.setResult(ex.getLocalizedMessage());
            this.resultCode = -1;
        }
        List actions = e.getChildren("Action", Command.NAMESPACE_JDOM);
        for (int i = 0; i < actions.size(); ++i) {
            try {
                this.parseAction((Element)actions.get(i));
                continue;
            }
            catch (ManagementException e1) {
                System.err.println("Error while parsing action!!!");
            }
        }
    }

    private void parseAction(Element action) throws ManagementException {
        Element command = (Element)action.getChildren().get(0);
        if (command == null) {
            System.err.println("Error while parsing command!!!");
            return;
        }
        String res = null;
        if ("Bind".equals(command.getName())) {
            String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
            String wsdl = command.getChildText("Wsdl", Command.NAMESPACE_JDOM).trim();
            ArrayList<String> args = new ArrayList<String>();
            args.add(url);
            args.add(wsdl);
            BindCommand impl = new BindCommand();
            impl.process(args);
            res = "Bind result: " + impl.getResult();
        } else if ("Expose".equals(command.getName())) {
            String serviceLocalPart = command.getChild("ServiceName", Command.NAMESPACE_JDOM).getTextTrim();
            String serviceNamespace = command.getChild("ServiceNamespace", Command.NAMESPACE_JDOM).getTextTrim();
            String endpoint = command.getChildTextTrim("EndpointName", Command.NAMESPACE_JDOM);
            ArrayList<String> args = new ArrayList<String>();
            args.add(serviceNamespace);
            args.add(serviceLocalPart);
            args.add(endpoint);
            ExposeCommand expose = new ExposeCommand();
            expose.process(args);
            res = "Expose result : " + expose.getResult();
        } else if ("Deploy".equals(command.getName())) {
            String main = command.getChild("MainResource", Command.NAMESPACE_JDOM).getTextTrim();
            List resourcesElement = command.getChildren("Resource", Command.NAMESPACE_JDOM);
            ArrayList<String> resources = new ArrayList<String>();
            resources.add(main);
            for (int i = 0; i < resourcesElement.size(); ++i) {
                resources.add(((Element)resourcesElement.get(i)).getTextTrim());
            }
            DeployCommand deploy = new DeployCommand();
            deploy.process(resources);
            res = "Deploy : " + deploy.getResult();
        } else if ("Proxify".equals(command.getName())) {
            String url = command.getChild("Url", Command.NAMESPACE_JDOM).getTextTrim();
            String wsdl = command.getChildText("Wsdl", Command.NAMESPACE_JDOM).trim();
            ArrayList<String> args = new ArrayList<String>();
            args.add(url);
            args.add(wsdl);
            ProxifyCommand proxy = new ProxifyCommand();
            proxy.process(args);
            res = "Proxify : " + proxy.getResult();
        } else if ("AddNeighbourNode".equals(command.getName())) {
            String url = command.getChildText("NeighbourAdminAddress", Command.NAMESPACE_JDOM);
            ArrayList<String> args = new ArrayList<String>();
            args.add(url);
            AddNeighbourNodeCommand add = new AddNeighbourNodeCommand();
            add.process(args);
            res = "AddNeighbourNode : " + add.getResult();
        }
        if (this.getResult() == null) {
            this.setResult(res);
        } else {
            this.setResult(this.getResult() + "\n" + res);
        }
    }

    @Override
    public int doProcess(List<String> args) {
        int res = 1;
        this.confFile = new File(args.get(0));
        this.execute();
        res = this.resultCode;
        return res;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        if (args == null) {
            return false;
        }
        return args.size() == 1;
    }

    @Override
    public int process(List<String> args) {
        this.setResult(null);
        int result = 1;
        result = !this.validateArgs(args) ? -2 : this.doProcess(args);
        System.out.println(this.getResult());
        return result;
    }

    public String toString() {
        return "p <conf-file> \t\t\t\t\t{Parse Configuration File}";
    }

    @Override
    public void reset() {
        super.reset();
        this.cr.setHost("no-connection");
    }
}

