/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.cli.impl.CommandReader;
import esstar.petalslink.com.data.management.user._1.Ping;
import esstar.petalslink.com.data.management.user._1.PingResponse;
import java.util.List;

public class Connectcommand
extends AbstractCommand {
    private CommandReader cr;

    public Connectcommand(CommandReader cr) {
        this.setShortcut("c");
        this.setDescription("connect");
        this.setName("Connect");
        this.cr = cr;
    }

    @Override
    public void execute() {
        try {
            this.resetClient();
            Ping parameters = new Ping();
            PingResponse res = this.getClient().ping(parameters);
            this.setResult("Connection ok " + res.getNodeInformation().getName() + ", " + res.getNodeInformation().getVersion());
            this.resultCode = 1;
            this.cr.setHost(this.getServiceAddress());
        }
        catch (Throwable e) {
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
            this.setServiceAddress(null);
            this.resetClient();
            this.cr.setHost("no-connection");
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.setServiceAddress(args.get(0));
        this.execute();
        if (this.getClient() == null) {
            return -1;
        }
        return 1;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        if (args == null) {
            return false;
        }
        return args.size() == 1;
    }

    @Override
    public int process(List<String> args) {
        int result = 1;
        result = !this.validateArgs(args) ? -2 : this.doProcess(args);
        System.out.println(this.getResult());
        return result;
    }

    public String toString() {
        return "c <host> \t\t\t\t\t\t{Connect to ESB node via admin service}";
    }

    @Override
    public void reset() {
        super.reset();
        this.cr.setHost("NOCONNECTION");
    }
}

