/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl;

import com.ebmwebsourcing.easyesb.cli.impl.CommandReader;
import com.ebmwebsourcing.easyesb.cli.impl.SystemExitHook;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.LogManager;

public class ESBClientLauncher {
    private static final String START_COMMAND = "start";
    private static final String SHUTDOWN_COMMAND = "shutdown";
    private static final String VERSION_COMMAND = "version";
    protected ESBCoreFactory factory = null;
    private String banner = " -----------------------------------------------------------\n|                                                           |\n|                   EasyESB Client                          |\n|             EBM Research Enterprise Service Bus           |\n|               http://research.petalslink.org              |\n|                                                           |\n -----------------------------------------------------------\n";
    private static final String LOGGER_FILE = "/logger/easyesb-logging.properties";
    private SystemExitHook systemExitHook;

    protected void showBanner() {
        System.out.println();
        System.out.println(this.banner);
        System.out.println();
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public void launch(String[] args) {
        this.showBanner();
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args.length == 0) {
            command.add(START_COMMAND);
        }
        for (String arg : args) {
            command.add(arg);
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("ESB client is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("ESB client is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(command);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                    this.systemExitHook.run();
                }
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    public void start() throws Exception {
        this.systemExitHook = new SystemExitHook();
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook();
        }
        this.systemExitHook.start();
    }

    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the ESB container");
        System.out.println(" -shutdowm               shutdown the ESB container");
        System.out.println(" -version                get the ESB container version");
    }

    private void printStartedMessage() {
        this.printSpecificStartMessage();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        System.out.println();
        System.out.println("ESB " + this.getDistributionName() + " distribution successfully started - " + sdf.format(date));
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(List<String> command) throws Exception {
        CommandReader console = new CommandReader();
        command.remove(START_COMMAND);
        if (command.size() == 0) {
            console.read();
        } else {
            List<String> commands = this.parse(command);
            for (String com : commands) {
                console.processCommandLine(com);
            }
        }
    }

    private List<String> parse(List<String> command) {
        ArrayList<String> res = new ArrayList<String>();
        boolean newcommand = true;
        String tmp = "";
        for (String s : command) {
            if (s.equals("c") || s.equals("p") || s.equals("pr") || s.equals("b") || s.equals("e") || s.equals("d") || s.equals("a")) {
                if (newcommand) {
                    tmp = s;
                    newcommand = false;
                    continue;
                }
                res.add(tmp);
                newcommand = false;
                tmp = s;
                continue;
            }
            tmp = tmp + " " + s;
        }
        res.add(tmp);
        System.out.println("commands : " + res);
        return res;
    }

    public String getDistributionName() {
        return "ESB client v1.0 SNAPSHOT";
    }

    public SystemExitHook getSystemExitHook() {
        return this.systemExitHook;
    }

    public void setSystemExitHook(SystemExitHook systemExitHook) {
        this.systemExitHook = systemExitHook;
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger/easyesb-logging.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : ESBClientLauncher.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

