/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.di.api;

import com.ebmwebsourcing.bpmneditor.business.domain.di.impl.BPMNLabelStyle;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.ILabel;

/**
 * A BPMN label is not a top-level element but is always nested inside either a BPMNShape or a BPMNEdge. It does not
 * have its own reference to a BPMN element but rather inherits that reference (if any) from its parent shape or edge. The
 * textual info depicted by the label is derived from that referenced BPMN element.
 * 
 * <b>Note:</b> The bounds of BPMNLabel are always relative to
 *  the containing plane’s origin point.
 * @author nfleury
 *
 */
public interface IBPMNLabel extends ILabel{

	BPMNLabelStyle getBPMNLabelStyle();
	
}
