/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.di.impl;

import java.util.HashSet;

import com.ebmwebsourcing.bpmneditor.business.domain.di.api.IBPMNDiagram;
import com.ebmwebsourcing.bpmneditor.business.domain.di.api.IBPMNPlane;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IStyle;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl.Diagram;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HasModelManager;

public class BPMNDiagram extends Diagram implements IBPMNDiagram{
	
	private IBPMNPlane rootElement;
	
	public BPMNDiagram() {
		super();
		this.rootElement = new BPMNPlane();
	}
	
	public void setRootElement(IBPMNPlane rootElement) {
		this.rootElement = rootElement;
	}
	
	@Override
	public IBPMNPlane getRootElement() {
		return rootElement;
	}
	
	@Override 
	public HasModelManager getClone() {
		BPMNDiagram d = new BPMNDiagram();
		
		d.setId(this.getId());
		d.setName(this.getName());
		d.setResolution(this.getResolution());
		if(this.getRootElement()!=null){
			d.setRootElement((IBPMNPlane) this.getRootElement().getClone());
			
			if(this.getStyles()!=null){
				HashSet<IStyle> styles = new HashSet<IStyle>();
				for(BPMNLabel label : ((BPMNPlane)d.getRootElement()).getAllLabels()){
					if(label.getBPMNLabelStyle()!=null){
						styles.add(label.getBPMNLabelStyle());
					}
				}
				d.setStyles(styles);
			}
		}
		
		return d;
	} 
	
}
