/**
 * bpmn-di - BPMN graphical layer domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.business.domain.di.impl;

import com.ebmwebsourcing.bpmneditor.business.domain.di.api.IBPMNLabelStyle;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.Font;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl.Style;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HasModelManager;

public class BPMNLabelStyle extends Style implements IBPMNLabelStyle{
	
	private Font font;
	
	public BPMNLabelStyle(){
		super();
	}
	
	public void setFont(Font font){
		this.font = font;
	}
	
	public Font getFont() {
		return font;
	}

	@Override 
	public HasModelManager getClone() {
		BPMNLabelStyle s = new BPMNLabelStyle();
		
		s.setId(this.getId());
		s.setFont(this.getFont());
		
		return s;
	}
	
}