/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.helper.designer;

import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.event.DesignerCompleteEvent;
import com.google.gwt.user.client.Timer;

public final class DesignerEngine extends Timer {

	private DiagramDesigner designer;

	private int actualActionKey;

	protected DesignerEngine(DiagramDesigner designer) {
		this.designer = designer;

	}

	@Override
	public void run() {
		if (actualActionKey < this.designer.actions.size()) {
			try {
				this.designer.actions.get(actualActionKey).execute();
			} catch (Exception e) {
				System.out.println(e);
			} finally {
				actualActionKey++;
			}
		} else {
			cancel();
			this.designer.fireEvent(new DesignerCompleteEvent());
		}
	}

}
