/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.helper.designer;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.event.DiagramElementPropertyChangeEvent;

public class DiagramElementProxy<T extends IModelElement>{

	private IDiagramElementView diagramElement;
	
	private DiagramDesigner designer;
	
	public DiagramElementProxy(DiagramDesigner designer) {
		
		this.designer = designer;
		
	}
	
	public IDiagramElementView getDiagramElement() {
		return diagramElement;
	}
	
	protected void setDiagramElement(IDiagramElementView diagramElement) {
		this.diagramElement = diagramElement;
	}
	
	public void changePropertyValue(final String fieldName,final Object value){
		designer.addAction(new IAction() {
			@Override
			public void execute() {
				designer.fireEvent(new DiagramElementPropertyChangeEvent(fieldName, value,getDiagramElement()));
			}
		});
	}
	
	public void assertStateEquals(){
		
	}
	
	public void assertIsConformToRule(Class<? extends IDiagramElementViewConformityRule> ruleClazz){
		designer.assertElementIsConformToRule(this, ruleClazz);
	}
	
	public void assertIsNotConformToRule(Class<? extends IDiagramElementViewConformityRule> ruleClazz){
		designer.assertElementIsNotConformToRule(this, ruleClazz);
	}
	
	
}
