/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IHideRulesNotificationWithLevelEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IRuleNotificationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.google.gwt.event.shared.GwtEvent;

public class ShowRulesNotificationWithLevelEvent extends GwtEvent<IRuleNotificationHandler> implements IHideRulesNotificationWithLevelEvent{
	
	public static Type<IRuleNotificationHandler> TYPE = new Type<IRuleNotificationHandler>();
	
	private RuleLevel ruleLevel;
	private HashSet<IConformityRule> rules;
	
	public ShowRulesNotificationWithLevelEvent(RuleLevel ruleLevel,HashSet<IConformityRule> rules) {
		this.ruleLevel 	= ruleLevel;
		this.rules 		= rules;
	}
	
	@Override
	protected void dispatch(IRuleNotificationHandler handler) {
		handler.onHideRulesNotificationWithLevel(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IRuleNotificationHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public RuleLevel getRuleLevel() {
		return ruleLevel;
	}

	@Override
	public HashSet<IConformityRule> getRules() {
		return rules;
	}
	

}
