/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.modeleditor;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.events.IEditorViewHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.modeleditor.events.SelectedModelsChangeEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditorProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.ITemplate;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;

public class EditorView extends Composite implements IEditorView{
	
	private AbsolutePanel mainPanel;
	private List<IEditorModel> selectedModels;
	
	private ITemplate template;
	private HandlerManager handlerManager;
	private IMainModelElement dataProvider;

	
	public EditorView() {
		this.mainPanel = new AbsolutePanel();
		this.handlerManager = new HandlerManager(this);
		initWidget(mainPanel);
		this.getElement().setAttribute("style", "overflow-y:scroll;height:100%;");
	}
	
	@Override
	public void refresh() {
		if (template !=null ) this.mainPanel.remove(template);
		
		if (selectedModels.size()>0){
			IHasEditorProxy editorProxy = (IHasEditorProxy) selectedModels.get(0);
			this.template = editorProxy.getEditor(getDataProvider());
			this.mainPanel.add(template);
		}
	}
	
	@Override
	public void setSelectedElements(List<IEditorModel> selectedElements) {
		this.selectedModels = selectedElements;
		this.fireEvent(new SelectedModelsChangeEvent(selectedElements));
		this.refresh();
	}

	@Override
	public void addHandler(IEditorViewHandler handler) {
		handlerManager.addHandler(SelectedModelsChangeEvent.TYPE, handler);
	}
	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}

	@Override
	public void setSelectedElement(IEditorModel selectedElement) {
		List<IEditorModel> elements = new ArrayList<IEditorModel>();
		elements.add(selectedElement);
		setSelectedElements(elements);
	}

	@Override
	public IMainModelElement getDataProvider() {
		return dataProvider;
	}

	@Override
	public void setDataProvider(IMainModelElement mainModel) {
		this.dataProvider = mainModel;
	}
	
}
;