/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.validation;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IHideContextualNotificationsEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IHideRulesNotificationWithLevelEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.INotificationSelectedEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IRuleNotificationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IRuleResolvedEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IShowContextualNotificationsEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IShowRulesNotificationWithLevelEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationFailureEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationStartEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationSuccessEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.validation.IValidationWarningEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.notification.MessageType;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.notification.NotificationBubble;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;

public class DefaultValidationNotificationHandler implements
		IValidationHandler, IRuleNotificationHandler {

	private HashMap<IDiagramElementViewConformityRule, ContextualNotificationBubble> bubbles;


	
	public DefaultValidationNotificationHandler() {
		this.bubbles = new HashMap<IDiagramElementViewConformityRule, ContextualNotificationBubble>();

	}

	@Override
	public void onValidationFailure(IValidationFailureEvent event) {

		for (IConformityRule r : event.getRulesInFailure()) {

			if (r instanceof IDiagramElementViewConformityRule) {

				final IDiagramElementViewConformityRule rule = (IDiagramElementViewConformityRule) r;

				ContextualNotificationBubble b = bubbles.get(rule);
				final IDiagramElementView view = rule.getNonConformElement();
				
				final IDiagramView diagamView = (IDiagramView) view.getUIPanel();
				
				if (b == null) {

					b = new ContextualNotificationBubble();
					b.setTitle(rule.getRuleName());
					b.setMessage(rule.getResolveConformityDescription());

					if (rule.getRuleLevel() == RuleLevel.WARNING) {
						b.setMessageType(MessageType.WARNING);
					} else if (rule.getRuleLevel() == RuleLevel.ERROR) {
						b.setMessageType(MessageType.ERROR);
					}

					final ContextualNotificationBubble bproxy = b;
					b.setTitleVisible(false);
					b.setMessageVisible(false);

					b.addMouseOverHandler(new MouseOverHandler() {

						@Override
						public void onMouseOver(MouseOverEvent event) {

							bproxy.setTitleVisible(true);
							bproxy.setMessageVisible(true);
						}

					});

					b.addMouseOutHandler(new MouseOutHandler() {

						@Override
						public void onMouseOut(MouseOutEvent event) {

							bproxy.setTitleVisible(false);
							bproxy.setMessageVisible(false);

						}
					});

					//destroy bubble when element is removed
					diagamView.addUIPanelHandler(new IUIPanelHandler() {
						
						@Override
						public void onUnSelectUIElement(
								IUnselectedElementsEvent unselectedElementsEvent) {}
						
						@Override
						public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {}
						
						@Override
						public void onResizeRequest(IResizeRequestEvent event) {}
						
						@Override
						public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
							
							if (removeElementEvent.getRemovedElement().equals(view)){
								bubbles.remove(rule);
							}
							
						}
						
						@Override
						public void onNewUIElement(INewUIElementEvent newElementEvent) {}
					});

					// if concerned elements is a draggable update notice
					// position
					// TODO: update position when view parent moves
					if (view instanceof IDraggableElement) {

						IDraggableElement draggable = (IDraggableElement) view;

						draggable.addDragHandler(new DragHandler() {

							@Override
							public void onStop(IDragStopEvent event) {}

							@Override
							public void onStart(IDragStartEvent event) {
								
								bproxy.hide();

							}

							@Override
							public void onRefusedBeforeDrop(
									IRefusedBeforeDropEvent event) {}

							@Override
							public void onRefusedAfterDrop(
									IRefusedAfterDropEvent event) {}

							@Override
							public void onMove(IDragMoveEvent event) {}

							@Override
							public void onAcceptedBeforeDrop(
									IAcceptedBeforeDropEvent event) {}

							@Override
							public void onAcceptedAfterDrop(
									IAcceptedAfterDropEvent event) {}
						});

					}
					
					
					bproxy.hide();
					diagamView.setContextualNotification(
							view.getAbsoluteLeft() - diagamView.getAbsoluteLeft() + diagamView.getScrollLeft(),
							(view.getAbsoluteTop()- diagamView.getAbsoluteTop() - bproxy.getOffsetHeight() + diagamView.getScrollTop()),bproxy);

					bubbles.put(rule, b);

				}

			}

		}

	}

	public void hideAllNotifications() {

		for (NotificationBubble b : bubbles.values()) {

			b.hide();

		}

	}

	public void showAllNotifications() {

		for(IDiagramElementViewConformityRule rule: bubbles.keySet()){
			
			show(rule);
			
		}

	}

	@Override
	public void onValidationSuccess(IValidationSuccessEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onValidationWarning(IValidationWarningEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onHideRulesNotificationWithLevel(
			IHideRulesNotificationWithLevelEvent event) {
		
		

	}

	@Override
	public void onNotificationSelected(INotificationSelectedEvent event) {


		if (event.getSelectedRule() instanceof IDiagramElementViewConformityRule){
			
			IDiagramElementViewConformityRule rule = (IDiagramElementViewConformityRule) event.getSelectedRule();
			
			show(rule);
		}


	}
	
	private void show(IDiagramElementViewConformityRule rule){
		
		ContextualNotificationBubble b = bubbles.get(rule);
		

		if (b != null){
			b.show();
			IDiagramElementView view = (IDiagramElementView) rule.getNonConformElement();
			
			IDiagramView diagramView = (IDiagramView) view.getUIPanel();
			
			diagramView.setContextualNotification(
					(int) view.getAbsoluteLeft()-diagramView.getAbsoluteLeft()  + diagramView.getScrollLeft(),
					(int) (view.getAbsoluteTop()-diagramView.getAbsoluteTop() - b.getOffsetHeight() + diagramView.getScrollTop()),b);

		}
	
	}
	
	@Override
	public void onRuleResolved(IRuleResolvedEvent event) {
		
		//System.out.println("Rule resolved:"+event.getResolvedRule().getRuleName());
		
		//remove the concerned bubble
		ContextualNotificationBubble b = bubbles.remove(event.getResolvedRule());
		if (b!=null) b.hide();
		
	}

	@Override
	public void onShowRulesNotificationWithLevel(
			IShowRulesNotificationWithLevelEvent event) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onValidationStart(IValidationStartEvent event) {
		hideAllNotifications();
		bubbles.clear();
	}

	@Override
	public void onHideContextualNotifications(
			IHideContextualNotificationsEvent event) {
		
		hideAllNotifications();
		
		
	}

	@Override
	public void onShowContextualNotifications(
			IShowContextualNotificationsEvent event) {
		
		showAllNotifications();
		
	}

}
