/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.validation;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.IDiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleNotificationRegistry;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleNotificationView;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.events.validation.NotificationSelectedEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;

public class RuleNotificationView extends Composite implements IRuleNotificationView{
	
	private IRuleNotificationRegistry model;
	
	private AbsolutePanel panel; 
	
	private IDiagramView diagramView;
	
	private HashSet<RuleNotificationViewElement> elements;
	
	private IDiagramController controller;
	
	private HorizontalPanel header;

	
	public RuleNotificationView(IDiagramView diagramView,IDiagramController controller) {
		
		this.diagramView 	= diagramView;
		this.controller  	= controller;
		this.model 			= controller.getNotificationRegistry();
		this.panel			= new AbsolutePanel();
		this.elements		= new HashSet<RuleNotificationViewElement>();
		
		this.header			= new HorizontalPanel();
		
		Label descriptionLabel = new Label("Description");
		
		descriptionLabel.setStyleName("notification-description");
		
		Label elementLabel     = new Label("Element") ;
		
		elementLabel.setStyleName("notification-element");
		
		Label typeLabel		   = new Label("Type");
		
		elementLabel.setStyleName("notification-type");
		
		Label fixAvailabelLabel = new Label("Fix available");
		
		fixAvailabelLabel.setStyleName("notification-fix-available");
		
		Label fixDescriptionLabel = new Label("Fix description"); 
		
		fixAvailabelLabel.setStyleName("notification-fix-description");
		
		this.header.add(descriptionLabel);
		this.header.add(elementLabel);
		this.header.add(typeLabel);
		this.header.add(fixAvailabelLabel);
		this.header.add(fixDescriptionLabel);
		
		//this.panel.add(header);
	
		initWidget(panel);

	}
	


	@Override
	public IRuleNotificationRegistry getModel() {
		return model;
	}

	@Override
	public void refresh() {
		
		removeViewElements();
		
		//Warnings
		for(final IConformityRule rule:model.getRulesInWarning()){
			
			RuleNotificationViewElement el = new RuleNotificationViewElement(this, rule); 
			
			el.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					
					controller.fireEvent(new NotificationSelectedEvent(rule));
					
				}
			});
			
			this.panel.add(el);
			this.elements.add(el);
		}
		
		//Error
		for(final IConformityRule rule:model.getRulesInFailure()){
			
			RuleNotificationViewElement el = new RuleNotificationViewElement(this, rule); 
			
			el.addClickHandler(new ClickHandler() {
				
				@Override
				public void onClick(ClickEvent event) {
					
					controller.fireEvent(new NotificationSelectedEvent(rule));
					
				}
			});
			this.elements.add(el);
			this.panel.add(el);
			
		}
		
	}
	
	
	private void removeViewElements(){
	
		for(RuleNotificationViewElement el:elements){
			
			panel.remove(el);
			
		}
		
	}



	@Override
	public IDiagramView getDiagramView() {
		return diagramView;
	}



	@Override
	public IDiagramController getDiagramController() {
		return controller;
	}

}
