/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.selectable;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.events.ISelectionHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HasHandlers;

public interface ISelectable extends IUIElement,HasMouseDownHandlers,HasMouseUpHandlers,HasClickHandlers, HasHandlers{

	/**
	 * Must return a list of absolute values of intersection points
	 * The intersection points are the point which have to be in the user selection
	 * in order to make the selection of the element succeed  
	 * @return
	 */
	HashMap<Direction,Point> getIntersectionPoints();
	
	ISelectableDefaultHandlers getSelectableDefaultHandlers();
	
	void addSelectionHandler(ISelectionHandler handler);
	
	HandlerManager getHandlerManager();
}
