/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable;

import java.util.HashMap;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorStart;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.MouseState;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragStartEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;

public abstract class ConnectorPoint extends Composite implements IConnectorPoint,DragHandler{
	
	private HandlerManager handlerManager;
	private IUIPanel uiPanel;
	
	private MouseState mouseState;
	private DraggableElementDefaultHandlers draggableDefaultHandlers;
	
	private IContainer container;
	private IConnector connector;
	private IMagnet connectedToMagnet;
	
	private IConnectorPoint previousPoint;
	private IConnectorPoint nextPoint;
	
	
	public ConnectorPoint(final IConnector connector) {
		this.connector		= connector;
		this.handlerManager = new HandlerManager(this);
		
		this.uiPanel 		= connector.getUIPanel();
		
		this.mouseState		= new MouseState();
		
		
		this.draggableDefaultHandlers = new DraggableElementDefaultHandlers(this);
		this.draggableDefaultHandlers.attachDefaultHandlers();
		
		this.container		= uiPanel;
		
		this.addDragHandler(this);
		
		//when clicking on connector point => select connector
		this.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				event.stopPropagation(); //otherwise click propagates to uipanel and immediately causes unselect
				HashMap<String,ISelectable> selectedElements = new HashMap<String,ISelectable>();
				selectedElements.put(connector.getId(), connector);
				connector.getUIPanel().setSelectedElements(selectedElements);
			
				
			}
		});
		
	}
	
	@Override
	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
	}
	
	@Override
	public IConnector getConnector() {
		return this.connector;
	}
	
	@Override
	public void setNextPoint(IConnectorPoint nextPoint) {
		this.nextPoint = nextPoint;
	}
	
	@Override
	public void setPreviousPoint(IConnectorPoint previousPoint) {
		this.previousPoint = previousPoint;
	}
	
	@Override
	public IConnectorPoint getPreviousPoint() {
		return previousPoint;
	}
	
	@Override
	public IConnectorPoint getNextPoint() {
		return nextPoint;
	}
	
	@Override
	public abstract int getAbsoluteLeft();

	@Override
	public abstract int getAbsoluteTop();

	@Override
	public IContainer getContainer() {
		return this.container;
	}

	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return draggableDefaultHandlers;
	}

	@Override
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		HashSet<Class<? extends IUIElement>> draggedEl = new HashSet<Class<? extends IUIElement>>();
		
		return draggedEl;
	}

	@Override
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}

	@Override
	public String getId() {
		return this.getElement().getId();
	}

	@Override
	public IMagnet getConnectedToMagnet() {
		return this.connectedToMagnet;
	}
	
	@Override
	public void setConnectedToMagnet(IMagnet magnet) {
		this.connectedToMagnet = magnet;
	}
	
	
	
	
	@Override
	public IMouseState getMouseState() {
		return this.mouseState;
	}

	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getContainer().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}

	@Override
	public IUIPanel getUIPanel() {
		return uiPanel;
	}

	@Override
	public void setContainer(IContainer container) {		
	}

	@Override
    public void fireEvent(GwtEvent<?> event) {
    	super.fireEvent(event);
        handlerManager.fireEvent(event);
    }

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}
	
	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}

	@Override
	public void onMove(IDragMoveEvent event) {
		this.getConnector().refresh();
	}
	
	@Override
	public void onStart(IDragStartEvent event) {
		this.getConnector().refresh();
		
		//if current point is already attached => detach it
		if (this.getConnectedToMagnet()!=null){
			this.getConnectedToMagnet().removeConnectorPoint(this);
			
		
			//remove incoming or outgoing connector
			this.getConnectedToMagnet().getConnectableElement().getIncommingConnectors().remove(this.getConnector());			
			this.getConnectedToMagnet().getConnectableElement().getOutgoingConnectors().remove(this.getConnector());
			
			this.setConnectedToMagnet(null);
			
			if (this instanceof IConnectorStart){
				
				this.getConnector().setSource(null);
			
			}else if (this instanceof IConnectorEnd){
			
				this.getConnector().setTarget(null);
			
			}
			
			
		}
		
	}
	
	@Override
	public void onStop(IDragStopEvent event) {
		this.getConnector().refresh();
	}
	
	@Override
	public String toString() {
		return "relativeX:"+getRelativeX()+"relativeY:"+getRelativeY();
	}
	
}
