/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggable;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.DragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.Selectable;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.HandlerRegistration;


public abstract class Draggable extends Selectable implements IDraggable{
	
	private DraggableElementDefaultHandlers draggableDefaultHandlers;
	

	
	public Draggable(IUIPanel uiPanel, String id) {
		super(uiPanel, id);
	

		//make current element draggable
		this.draggableDefaultHandlers = new DraggableElementDefaultHandlers(this);
		draggableDefaultHandlers.attachDefaultHandlers();
		
		//Prevent default behaviors that may interfere with our interactions
		this.addMouseMoveHandler(new MouseMoveHandler() {
			
			
			public void onMouseMove(MouseMoveEvent event) {
				
				event.preventDefault();
				
			}
		});
		this.addMouseDownHandler(new MouseDownHandler() {
			
			
			public void onMouseDown(MouseDownEvent event) {
				event.preventDefault();
				
			}
		});
		this.addMouseUpHandler(new MouseUpHandler() {
			
			
			public void onMouseUp(MouseUpEvent event) {
				event.preventDefault();
			}
		});

		
		
	}
	


	@Override
	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedBeforeDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedAfterDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(RefusedBeforeDropEvent.TYPE,(DragHandler)dragHandler);
		handlerManager.addHandler(RefusedAfterDropEvent.TYPE,(DragHandler)dragHandler);
	}

	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return draggableDefaultHandlers;
	}

	

	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}


	public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
		return addDomHandler(handler, DoubleClickEvent.getType());
	}

	


}
