/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.selectable;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectableDefaultHandlers;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;

public class SelectableDefaultHandlers implements ISelectableDefaultHandlers {

	private ISelectable selectable;
	private MouseDownHandler mouseDownHandler;
	private MouseUpHandler mouseUpHandler;
	
	public SelectableDefaultHandlers(ISelectable selectable) {
		
		this.selectable = selectable;
		
		this.createListeners();
	}
	
	
	private void createListeners(){
		

		this.mouseDownHandler = new MouseDownHandler() {
			
			@Override
			public void onMouseDown(MouseDownEvent event) {
				
				event.stopPropagation();
				
				HashMap<String, ISelectable> selectedElements = new HashMap<String, ISelectable>();
				selectedElements.put(selectable.getId(), selectable);
				
				selectable.getUIPanel().setSelectedElements(selectedElements);
				
			}
		
		};
		
		//stop propagation on mouse up
		//otherwise mouse up propagates to uiPanel
		//causing unselect right after select
		this.mouseUpHandler = new MouseUpHandler() {
			
			@Override
			public void onMouseUp(MouseUpEvent event) {
				
				//event.stopPropagation();
				
			}
		};
		
		
		selectable.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				event.stopPropagation();
				
			}
		});
		
	}



	@Override
	public void attachDefaultHandlers() {
		
		selectable.addMouseDownHandler(mouseDownHandler);
		selectable.addMouseUpHandler(mouseUpHandler);
	}


	@Override
	public IUIElement getUIElement() {
		return selectable;
	}


	@Override
	public MouseDownHandler getDefaultMouseDownHandler() {
		return mouseDownHandler;
	}



	
	
}
