/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.notification.extension.test;

import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationReader;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.test.Util;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.w3c.dom.Document;

public class TestWSBrokeredNotificationDefinitionWithExtension
extends TestCase {
    public void testReadRegisterPublisher() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        System.out.println("\n\t testReadRegisterPublisher() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/RegisterPublisher.xml"));
        System.out.println("\n\t ========== \n xml file imported :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        RegisterPublisher descRP = WSNotificationReader.getInstance().readRegisterPublisher(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check RegisterPublisher attributs value : \n ");
        Assert.assertNotNull((Object)descRP);
        Assert.assertNotNull((Object)descRP.getTopic());
        Assert.assertNotNull((Object)descRP.getPublisherReference());
        EndpointReferenceType publisherRef = descRP.getPublisherReference();
        Assert.assertEquals((String)"http://petals.ow2.org/cdk", (String)publisherRef.getAddress());
        System.out.println(publisherRef.getAddress());
        ReferenceParametersType refParams = (ReferenceParametersType)publisherRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParams);
        SOAParameterType soaParams = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParams);
        Assert.assertNotNull((Object)soaParams);
        System.out.println("Service QName : " + soaParams.getService());
        System.out.println("Interface QName : " + soaParams.getInterface());
        System.out.println("Endpoint Name : " + soaParams.getEndpoint());
        ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParams);
        Assert.assertNotNull((Object)rUuids);
        List resourceIds = rUuids.getUuids();
        Assert.assertNotNull((Object)resourceIds);
        for (String id : resourceIds) {
            System.out.println(id);
        }
        Assert.assertNotNull((Object)descRP.getTopic());
        List topics = descRP.getTopic();
        System.out.println("Topic list :");
        for (TopicExpressionType topic : topics) {
            System.out.println("~~~~~~ ");
            System.out.println(topic.getDialect());
            System.out.println(topic.getTopicNameSpace());
            System.out.println(topic.getContent());
            System.out.println("~~~~~~ ");
        }
    }

    public void testWriterRegisterPublisher() throws URISyntaxException, WSNotificationException {
        System.out.println("\n\t testWriterRegisterPublisher() method outputs :\n");
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/RegisterPublisher.xml"));
        RegisterPublisher regPub = WSNotificationReader.getInstance().readRegisterPublisher(docDesc);
        Assert.assertNotNull((Object)regPub);
        Document docWrotten = WSNotificationWriter.getInstance().writeRegisterPublisher(regPub);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n \n testWriteRegisterPublisher() - payload written  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRegisterPublisher() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        RegisterPublisher registerPublisherPayload = WSNotificationFactory.getInstance().createRegisterPublisher();
        registerPublisherPayload.setDemand(Boolean.valueOf(true));
        GregorianCalendar gCalendar = new GregorianCalendar();
        registerPublisherPayload.setInitialTerminationTime(gCalendar.getTime());
        EndpointReferenceType producerEdpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        producerEdpRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)producerEdpRef.newReferenceParameters();
        producerEdpRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org/petals-se-WsnProducer", "NotificationProducerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationProducer"));
        soaParam.setEndpoint("NotificationProducerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        registerPublisherPayload.setPublisherReference(producerEdpRef);
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("tns1", "http://a/given/topic/namespace");
        topic.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
        topic.setContent("tns1:aGivenTopic/toto/subsubtopic/*");
        registerPublisherPayload.addTopic(topic);
        Assert.assertNotNull((Object)registerPublisherPayload);
        Document doc = WSNotificationWriter.getInstance().writeRegisterPublisher(registerPublisherPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateRegisterPublisher() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadRegisterPublisherResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/RegisterPublisherResponse.xml"));
        System.out.println("\n\t ========== \n \n testReadRegisterPublisherResponse() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        RegisterPublisherResponse descRPResp = WSNotificationReader.getInstance().readRegisterPublisherResponse(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check RegisterPublisherResponse attributs value : \n ");
        Assert.assertNotNull((Object)descRPResp);
        EndpointReferenceType registrationRef = descRPResp.getPublisherRegistrationReference();
        Assert.assertNotNull((Object)registrationRef);
        System.out.println(registrationRef.getAddress());
        ReferenceParametersType refParams = (ReferenceParametersType)registrationRef.getReferenceParameters();
        Assert.assertNotNull((Object)refParams);
        SOAParameterType soaParams = WsnSpecificTypeHelper.getSOAParameter((ReferenceParametersType)refParams);
        Assert.assertNotNull((Object)soaParams);
        System.out.println("Service QName : " + soaParams.getService());
        System.out.println("Interface QName : " + soaParams.getInterface());
        System.out.println("Endpoint Name : " + soaParams.getEndpoint());
        ResourcesUuidType rUuids = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)refParams);
        Assert.assertNotNull((Object)rUuids);
        List resourceIds = rUuids.getUuids();
        Assert.assertNotNull((Object)resourceIds);
        for (String id : resourceIds) {
            System.out.println(id);
        }
    }

    public void testWriterRegisterPublisherResponse() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/RegisterPublisherResponse.xml"));
        RegisterPublisherResponse descRead = WSNotificationReader.getInstance().readRegisterPublisherResponse(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeRegisterPublisherResponse(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteRegisterPublisherResponse() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateRegisterPublisherResponse() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        RegisterPublisherResponse registerPublisherResponsePayload = WSNotificationFactory.getInstance().createRegisterPublisherResponse();
        EndpointReferenceType registrationRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        registrationRef.setAddress("http://petals.ow2.org/cdk");
        ReferenceParametersType ref = (ReferenceParametersType)registrationRef.newReferenceParameters();
        registrationRef.setReferenceParameters((AbsItfReferenceParametersType)ref);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setService(new QName("http://petals.ow2.org", "PublisherRegistrationManagerService"));
        soaParam.setInterface(new QName("http://docs.oasis-open.org/wsn/brw-2", "PublisherRegistrationProducer"));
        soaParam.setEndpoint("PublisherRegistrationManagerEndpoint");
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)ref);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (ReferenceParametersType)ref);
        registerPublisherResponsePayload.setPublisherRegistrationReference(registrationRef);
        Assert.assertNotNull((Object)registerPublisherResponsePayload);
        Document doc = WSNotificationWriter.getInstance().writeRegisterPublisherResponse(registerPublisherResponsePayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateRegisterPublisherResponse() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }

    public void testReadDestroyRegistration() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/DestroyRegistration.xml"));
        System.out.println("\n\t ========== \n \n testReadDestroyRegistration() - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docDesc));
        DestroyRegistration descDestReg = WSNotificationReader.getInstance().readDestroyRegistration(docDesc);
        System.out.println("\n ~~~ \n");
        System.out.println("Check DestroyRegistration attributs value : \n ");
        Assert.assertNotNull((Object)descDestReg);
        ResourcesUuidType uuidsToRemove = WsnSpecificTypeHelper.getResourcesUuidType((DestroyRegistration)descDestReg);
        Assert.assertNotNull((Object)uuidsToRemove);
        List resourceIds = uuidsToRemove.getUuids();
        Assert.assertNotNull((Object)resourceIds);
        for (String id : resourceIds) {
            System.out.println(id);
        }
    }

    public void testWriterDestroyRegistration() throws URISyntaxException, WSNotificationException {
        Document docDesc = Util.fromStreamToDocument(TestWSBrokeredNotificationDefinitionWithExtension.class.getResourceAsStream("/descriptors/DestroyRegistration.xml"));
        DestroyRegistration descRead = WSNotificationReader.getInstance().readDestroyRegistration(docDesc);
        Assert.assertNotNull((Object)descRead);
        Document docWrotten = WSNotificationWriter.getInstance().writeDestroyRegistration(descRead);
        Assert.assertNotNull((Object)docWrotten);
        System.out.println("\n\t ========== \n testWriteDestroyRegistration() - docWrotten - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)docWrotten));
    }

    public void testCreateDestroyRegistration() throws URISyntaxException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        DestroyRegistration destroyRegistrationPayload = WSNotificationFactory.getInstance().createDestroyRegistration();
        EndpointReferenceType edpRef = WSAddressingFactory.getInstance().newEndpointReferenceType();
        edpRef.setAddress("mail-address-sample@ebmwebsourcing.com");
        ReferenceParametersType refParam = (ReferenceParametersType)edpRef.newReferenceParameters();
        edpRef.setReferenceParameters((AbsItfReferenceParametersType)refParam);
        SOAParameterType soaParam = WSNotificationExtensionFactory.getInstance().createSOAParameterType();
        soaParam.setEndpoint("PublisherSubscriptionManagerEndpoint");
        soaParam.setInterface(new QName("http://toto", "SubscriptionManager"));
        soaParam.setService(new QName("http://toto", "SubscriptionManagerService"));
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParam, (ReferenceParametersType)refParam);
        ResourcesUuidType rUuids = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        rUuids.addUuid("uuid:" + UUID.randomUUID());
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)rUuids, (DestroyRegistration)destroyRegistrationPayload);
        Document doc = WSNotificationWriter.getInstance().writeDestroyRegistration(destroyRegistrationPayload);
        Assert.assertNotNull((Object)doc);
        System.out.println("\n\t ========== \n \n testCreateDestroyRegistration() - payload created  - xml :\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
    }
}

