/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rampart.AbstractUniqueMessageAttributeCache;

public class NonceCache
extends AbstractUniqueMessageAttributeCache {
    private final Map<Nonce, Calendar> mapIdNonce = new HashMap<Nonce, Calendar>();
    private final ReentrantLock lock = new ReentrantLock();

    public NonceCache() {
    }

    public NonceCache(int maxLifeTime) {
        super(maxLifeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToCache(String id, String userName) {
        Nonce nonce = new Nonce(id, userName);
        Calendar rightNow = Calendar.getInstance();
        this.lock.lock();
        try {
            this.mapIdNonce.put(nonce, rightNow);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean valueExistsInCache(String id, String userName) {
        this.lock.lock();
        try {
            this.clearStaleNonceIds();
        }
        finally {
            this.lock.unlock();
        }
        Nonce nonce = new Nonce(id, userName);
        return this.mapIdNonce.containsKey(nonce);
    }

    @Override
    public void clearCache() {
        this.lock.lock();
        try {
            this.mapIdNonce.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clearStaleNonceIds() {
        Calendar rightNow = Calendar.getInstance();
        int maxLifeTime = this.getMaximumLifeTimeOfAnAttribute();
        rightNow.add(13, -maxLifeTime);
        long timeBeforeMaxLifeTime = rightNow.getTimeInMillis();
        Iterator<Map.Entry<Nonce, Calendar>> iterator = this.mapIdNonce.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Nonce, Calendar> pair = iterator.next();
            Calendar itemDate = pair.getValue();
            long itemAddedTime = itemDate.getTimeInMillis();
            if (timeBeforeMaxLifeTime <= itemAddedTime) continue;
            iterator.remove();
        }
    }

    static class Nonce {
        String nonceValue;
        String userName;

        public Nonce(String nonce, String user) {
            this.nonceValue = nonce;
            this.userName = user;
        }

        public boolean equals(Object another) {
            if (another == null) {
                return false;
            }
            if (another == this) {
                return true;
            }
            if (!(another instanceof Nonce)) {
                return false;
            }
            Nonce otherNonce = (Nonce)another;
            return this.userName.equals(otherNonce.userName) && this.nonceValue.equals(otherNonce.nonceValue);
        }

        public int hashCode() {
            return this.userName.hashCode() * 13 + this.nonceValue.hashCode() * 7;
        }
    }
}

