/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.ServiceNonceCache;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.ValidatorData;
import org.apache.rampart.saml.SAMLAssertionHandlerFactory;
import org.apache.rampart.util.Axis2Util;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.KerberosToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.security.NamePasswordCallbackHandler;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.validate.KerberosTokenValidator;
import org.apache.ws.security.validate.Validator;

public class RampartEngine {
    private static final Logger LOGGER = LogManager.getLogger(RampartEngine.class);
    private static final Logger TIME_LOGGER = LogManager.getLogger((String)"org.apache.rampart.TIME");
    private static final ServiceNonceCache serviceNonceCache = new ServiceNonceCache();

    /*
     * Unable to fully structure code
     */
    public List<WSSecurityEngineResult> process(MessageContext msgCtx) throws WSSPolicyException, RampartException, WSSecurityException, AxisFault {
        dotDebug = RampartEngine.TIME_LOGGER.isDebugEnabled();
        RampartEngine.LOGGER.debug("Enter process(MessageContext msgCtx)");
        rmd = new RampartMessageData(msgCtx, false);
        rpd = rmd.getPolicyData();
        msgCtx.setProperty("rampartPolicyData", (Object)rpd);
        RampartUtil.validateTransport(rmd);
        if (rpd == null) {
            return null;
        }
        if (this.isSecurityFault(rmd) || !RampartUtil.isSecHeaderRequired(rpd, rmd.isInitiator(), true)) {
            env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
            msgCtx.setEnvelope(env);
            Axis2Util.useDOOM(false);
            RampartEngine.LOGGER.debug("Return process MessageContext msgCtx)");
            return null;
        }
        engine = new WSSecurityEngine();
        engine.setWssConfig(rmd.getConfig());
        rampartConfig = rpd.getRampartConfig();
        if (rampartConfig != null) {
            config = engine.getWssConfig();
            endSupptokens = rpd.getEndorsingSupportingTokens();
            if (endSupptokens != null && endSupptokens.getTokens() != null && endSupptokens.getTokens().size() > 0) {
                RampartEngine.LOGGER.debug("Processing endorsing supporting tokens");
                for (Token token : endSupptokens.getTokens()) {
                    if (!(token instanceof KerberosToken)) continue;
                    RampartEngine.LOGGER.debug("KerberosToken is found as part of the endorsing supporting tokens.Check for KerberosConfig.");
                    kerberosConfig = rampartConfig.getKerberosConfig();
                    if (null != kerberosConfig) {
                        RampartEngine.LOGGER.debug("KerberosConfig is found.");
                        RampartEngine.LOGGER.debug("Creating KerberosTokenValidor with the available KerberosConfig.");
                        kerberosValidator = new KerberosTokenValidator();
                        kerberosTokenDecoder = RampartUtil.getKerberosTokenDecoder(msgCtx, kerberosConfig);
                        if (kerberosTokenDecoder != null) {
                            kerberosValidator.setKerberosTokenDecoder(kerberosTokenDecoder);
                        }
                        kerberosValidator.setContextName(kerberosConfig.getJaasContext());
                        kerberosValidator.setServiceName(kerberosConfig.getServicePrincipalName());
                        serviceNameForm = kerberosConfig.getServicePrincipalNameForm();
                        if ("username".equals(serviceNameForm)) {
                            kerberosValidator.setUsernameServiceNameForm(true);
                        }
                        if (null == (principalName = kerberosConfig.getPrincipalName())) {
                            RampartEngine.LOGGER.debug("Principal name is not available in the KerberosConfig.Using the Rampart configuration's user.");
                            principalName = rampartConfig.getUser();
                        }
                        if ((password = kerberosConfig.getPrincipalPassword()) == null) {
                            RampartEngine.LOGGER.debug("Principal password is not available in the KerberosConfig.Trying with the configured Rampart password callback.");
                            handler = RampartUtil.getPasswordCB(rmd);
                            if (handler != null) {
                                cb = new WSPasswordCallback[]{new WSPasswordCallback(principalName, 7)};
                                try {
                                    handler.handle((Callback[])cb);
                                    if (cb[0].getPassword() == null || "".equals(cb[0].getPassword())) ** GOTO lbl56
                                    password = cb[0].getPassword();
                                }
                                catch (IOException | UnsupportedCallbackException e) {
                                    throw new RampartException("errorInGettingPasswordForUser", new String[]{principalName}, e);
                                }
                            } else {
                                RampartEngine.LOGGER.debug("No Rampart password handler is configured.");
                            }
                        }
lbl56:
                        // 5 sources

                        if (principalName != null && password != null) {
                            cb = new NamePasswordCallbackHandler(principalName, password);
                            kerberosValidator.setCallbackHandler((CallbackHandler)cb);
                        }
                        config.setValidator(WSSecurityEngine.BINARY_TOKEN, (Validator)kerberosValidator);
                        RampartEngine.LOGGER.debug("KerberosTokenValidator is configured and set for BINARY_TOKEN.");
                        continue;
                    }
                    RampartEngine.LOGGER.debug("KerberosConfig is not found.Skipping configurating and setting of a Kerberos validator.");
                }
            }
            engine.setWssConfig(config);
        }
        data = new ValidatorData(rmd);
        header = rmd.getMsgContext().getEnvelope().getHeader();
        if (header == null) {
            throw new RampartException("missingSOAPHeader");
        }
        headerBlocksIterator = header.getHeaderBlocksWithNamespaceURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        secHeader = null;
        if (headerBlocksIterator != null) {
            while (headerBlocksIterator.hasNext()) {
                elem = (SOAPHeaderBlock)headerBlocksIterator.next();
                if (!elem.getLocalName().equals("Security")) continue;
                secHeader = elem;
                break;
            }
        }
        if (secHeader == null) {
            throw new RampartException("missingSecurityHeader");
        }
        t0 = 0L;
        t1 = 0L;
        t2 = 0L;
        if (dotDebug) {
            t0 = System.currentTimeMillis();
        }
        if (!rmd.isInitiator()) {
            usernameTokens = RampartUtil.getUsernameTokens(rpd);
            for (UsernameToken usernameTok : usernameTokens) {
                if (!usernameTok.isNoPassword()) continue;
                RampartEngine.LOGGER.debug("Found UsernameToken with no password assertion in policy, configuring ws security processing to allow username tokens without password.");
                engine.getWssConfig().setAllowUsernameTokenNoPassword(true);
                break;
            }
        }
        actorValue = secHeader.getRole();
        signatureCrypto = RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader());
        tokenCallbackHandler = new TokenCallbackHandler(rmd.getTokenStorage(), RampartUtil.getPasswordCB(rmd));
        if (rpd.isSymmetricBinding()) {
            RampartEngine.LOGGER.debug("Processing security header using SymetricBinding");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
            if (rmd.isInitiator() && (msgCtx.getFLOW() == 1 || msgCtx.getFLOW() == 3)) {
                tokenCallbackHandler.removeEncryptedToken();
            }
        } else {
            RampartEngine.LOGGER.debug("Processing security header in normal path");
            results = engine.processSecurityHeader(rmd.getDocument(), actorValue, (CallbackHandler)tokenCallbackHandler, signatureCrypto, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), msgCtx.getAxisService().getClassLoader()));
        }
        if (dotDebug) {
            t1 = System.currentTimeMillis();
        }
        if (results != null) {
            for (WSSecurityEngineResult result : results) {
                actInt = (Integer)result.get((Object)"action");
                if (8 == actInt) {
                    samlAssertion = result.get((Object)"saml-assertion");
                    samlAssertionHandler = SAMLAssertionHandlerFactory.createAssertionHandler(samlAssertion);
                    if (samlAssertionHandler.isBearerAssertion()) break;
                    try {
                        store = rmd.getTokenStorage();
                        if (store.getToken(samlAssertionHandler.getAssertionId()) != null) continue;
                        token = new org.apache.rahas.Token(samlAssertionHandler.getAssertionId(), samlAssertionHandler.getAssertionElement(), samlAssertionHandler.getDateNotBefore(), samlAssertionHandler.getDateNotOnOrAfter());
                        token.setSecret(samlAssertionHandler.getAssertionKeyInfoSecret(signatureCrypto, tokenCallbackHandler));
                        store.add(token);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RampartException("errorInAddingTokenIntoStore", e);
                    }
                }
                if (1 == actInt) {
                    userNameTokenPrincipal = (WSUsernameTokenPrincipal)result.get((Object)"principal");
                    username = userNameTokenPrincipal.getName();
                    msgCtx.setProperty("username", (Object)username);
                    if (userNameTokenPrincipal.getNonce() == null) continue;
                    nonceLifeTimeInSeconds = 0;
                    if (rpd.getRampartConfig() != null) {
                        stringLifeTime = rpd.getRampartConfig().getNonceLifeTime();
                        try {
                            nonceLifeTimeInSeconds = Integer.parseInt(stringLifeTime);
                        }
                        catch (NumberFormatException e) {
                            RampartEngine.LOGGER.error("Invalid value for nonceLifeTime in rampart configuration file.", (Throwable)e);
                            throw new RampartException("invalidNonceLifeTime", e);
                        }
                    }
                    if (valueRepeating = RampartEngine.serviceNonceCache.isNonceRepeatingForService(serviceEndpointName = msgCtx.getAxisService().getEndpointName(), username, userNameTokenPrincipal.getNonce())) {
                        throw new RampartException("repeatingNonceValue", new Object[]{userNameTokenPrincipal.getNonce(), username});
                    }
                    RampartEngine.serviceNonceCache.addNonceForService(serviceEndpointName, username, userNameTokenPrincipal.getNonce(), nonceLifeTimeInSeconds);
                    continue;
                }
                if (2 != actInt) continue;
                cert = (X509Certificate)result.get((Object)"x509-certificate");
                if (rpd.isAsymmetricBinding() && cert == null && rpd.getInitiatorToken() != null && !rpd.getInitiatorToken().isDerivedKeys()) {
                    throw new RampartException("invalidSignatureAlgo");
                }
                msgCtx.setProperty("X509Certificate", (Object)cert);
            }
        }
        env = Axis2Util.getSOAPEnvelopeFromDOMDocument(rmd.getDocument(), true);
        if (dotDebug) {
            t2 = System.currentTimeMillis();
        }
        msgCtx.setEnvelope(env);
        Axis2Util.useDOOM(false);
        validator = RampartUtil.getPolicyValidatorCB(msgCtx, rpd);
        validator.validate(data, results);
        if (dotDebug) {
            t3 = System.currentTimeMillis();
            took1 = t1 - t0;
            took2 = t2 - t1;
            took3 = t3 - t2;
            RampartEngine.TIME_LOGGER.debug("processHeader by WSSecurityEngine took: {}, DOOM conversion took : {}, PolicyBasedResultsValidator took {}", new Supplier[]{(Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$process$0(long ), ()Ljava/lang/Object;)((long)took1), (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$process$1(long ), ()Ljava/lang/Object;)((long)took2), (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$process$2(long ), ()Ljava/lang/Object;)((long)took3)});
        }
        RampartEngine.LOGGER.debug("Return process(MessageContext msgCtx)");
        return results;
    }

    private boolean isSecurityFault(RampartMessageData rmd) {
        SOAPFault soapFault = rmd.getMsgContext().getEnvelope().getBody().getFault();
        return soapFault != null && RampartUtil.isSecurityFault(soapFault);
    }

    private static /* synthetic */ Object lambda$process$2(long took3) {
        return took3;
    }

    private static /* synthetic */ Object lambda$process$1(long took2) {
        return took2;
    }

    private static /* synthetic */ Object lambda$process$0(long took1) {
        return took1;
    }
}

