/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.rampart.NonceCache;
import org.apache.rampart.UniqueMessageAttributeCache;

public class ServiceNonceCache {
    private final Map<String, UniqueMessageAttributeCache> mapServiceNonceCache = Collections.synchronizedMap(new HashMap());

    public void addNonceForService(String service, String userName, String nonceValue, int nonceLifeTime) {
        UniqueMessageAttributeCache nonceCache;
        if (this.mapServiceNonceCache.containsKey(service)) {
            nonceCache = this.mapServiceNonceCache.get(service);
        } else {
            nonceCache = new NonceCache(nonceLifeTime);
            this.mapServiceNonceCache.put(service, nonceCache);
        }
        nonceCache.addToCache(nonceValue, userName);
    }

    public boolean isNonceRepeatingForService(String service, String userName, String nonceValue) {
        if (this.mapServiceNonceCache.containsKey(service)) {
            UniqueMessageAttributeCache nonceCache = this.mapServiceNonceCache.get(service);
            return nonceCache.valueExistsInCache(nonceValue, userName);
        }
        return false;
    }
}

