/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.rahas.EncryptedKeyToken;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.ws.security.WSPasswordCallback;
import org.w3c.dom.Element;

public class TokenCallbackHandler
implements CallbackHandler {
    private final TokenStorage store;
    private final CallbackHandler handler;
    private String tokenIdentifier;

    public TokenCallbackHandler(TokenStorage store, CallbackHandler handler) {
        this.store = store;
        this.handler = handler;
        this.tokenIdentifier = null;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callback;
                String id = pc.getIdentifier();
                if ((pc.getUsage() == 6 || pc.getUsage() == 7) && this.store != null) {
                    try {
                        Token tok = this.store.getToken(id);
                        if (tok == null) continue;
                        pc.setKey(tok.getSecret());
                        pc.setCustomToken((Element)tok.getToken());
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (pc.getUsage() == 9 && this.store != null) {
                    try {
                        String[] tokenIdentifiers;
                        for (String identifier : tokenIdentifiers = this.store.getTokenIdentifiers()) {
                            Token tok = this.store.getToken(identifier);
                            if (!(tok instanceof EncryptedKeyToken) || !((EncryptedKeyToken)tok).getSHA1().equals(id)) continue;
                            pc.setKey(tok.getSecret());
                            pc.setCustomToken((Element)tok.getToken());
                            this.tokenIdentifier = identifier;
                        }
                        continue;
                    }
                    catch (TrustException e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
                if (this.handler == null) continue;
                this.handler.handle(new Callback[]{pc});
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    public void removeEncryptedToken() {
        if (this.tokenIdentifier != null) {
            this.store.removeToken(this.tokenIdentifier);
        }
    }
}

