/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart;

import java.util.ArrayList;
import java.util.List;
import org.apache.rampart.RampartMessageData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorData {
    private final RampartMessageData rmd;
    final List<String> encryptedDataRefIds = new ArrayList<String>();
    private String bodyEncrDataId;

    public ValidatorData(RampartMessageData rmd) {
        this.rmd = rmd;
        this.extractEncryptedPartInformation();
    }

    private void extractEncryptedPartInformation() {
        Element start = this.rmd.getDocument().getDocumentElement();
        if (start != null) {
            this.extractEncryptedPartInformation(start);
        }
    }

    private void extractEncryptedPartInformation(Element parent) {
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            if (elem.getNamespaceURI() != null && elem.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#") && elem.getLocalName().equals("EncryptedData")) {
                if (parent.getLocalName().equals("Body") && parent.getNamespaceURI().equals(this.rmd.getSoapConstants().getEnvelopeURI())) {
                    this.bodyEncrDataId = elem.getAttribute("Id");
                    break;
                }
                this.encryptedDataRefIds.add(elem.getAttribute("Id"));
                break;
            }
            this.extractEncryptedPartInformation(elem);
        }
    }

    public List<String> getEncryptedDataRefIds() {
        return this.encryptedDataRefIds;
    }

    public RampartMessageData getRampartMessageData() {
        return this.rmd;
    }

    public String getBodyEncrDataId() {
        return this.bodyEncrDataId;
    }
}

